/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.data_loaders.resonance_processors;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.interaction.ResonanceProcessor;
import earth.terrarium.pastel.api.predicate.block.BrokenBlockPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ModifyDropsResonanceProcessor
extends ResonanceProcessor {
    public static final MapCodec<ModifyDropsResonanceProcessor> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BrokenBlockPredicate.CODEC.fieldOf("block").validate(block -> block.test(Blocks.AIR.defaultBlockState()) ? DataResult.error(() -> "Registering a Resonance Drop that matches on everything!") : DataResult.success((Object)block)).forGetter(c -> c.blockPredicate), (App)Codec.mapPair((MapCodec)Ingredient.CODEC_NONEMPTY.fieldOf("input"), (MapCodec)BuiltInRegistries.ITEM.byNameCodec().fieldOf("output")).codec().listOf().xmap(pairs -> pairs.stream().collect(() -> new HashMap(), (map, pair) -> map.put((Ingredient)pair.getFirst(), (Item)pair.getSecond()), (map1, map2) -> map1.putAll(map2)), map -> map.entrySet().stream().map(entry -> new Pair((Object)((Ingredient)entry.getKey()), (Object)((Item)entry.getValue()))).toList()).optionalFieldOf("modify_drops", Map.of()).forGetter(c -> c.modifiedDrops)).apply((Applicative)i, ModifyDropsResonanceProcessor::new));
    public Map<Ingredient, Item> modifiedDrops;

    public ModifyDropsResonanceProcessor(BrokenBlockPredicate blockTarget, Map<Ingredient, Item> modifiedDrops) {
        super(blockTarget);
        this.modifiedDrops = modifiedDrops;
    }

    @Override
    public boolean process(BlockState state, BlockEntity blockEntity, List<ItemStack> droppedStacks) {
        if (this.blockPredicate.test(state)) {
            this.modifyDrops(droppedStacks);
            return true;
        }
        return false;
    }

    private void modifyDrops(List<ItemStack> droppedStacks) {
        block0: for (ItemStack stack : droppedStacks) {
            for (Map.Entry<Ingredient, Item> modifiedDrop : this.modifiedDrops.entrySet()) {
                if (!modifiedDrop.getKey().test(stack)) continue;
                ItemStack convertedStack = modifiedDrop.getValue().getDefaultInstance();
                convertedStack.setCount(stack.getCount());
                droppedStacks.remove(stack);
                droppedStacks.add(convertedStack);
                continue block0;
            }
        }
    }

    @Override
    public MapCodec<? extends ResonanceProcessor> getCodec() {
        return CODEC;
    }

    public static Builder builder(BrokenBlockPredicate blockTarget) {
        return new Builder(blockTarget);
    }

    public static class Builder {
        private final BrokenBlockPredicate blockTarget;
        private final List<Map.Entry<Ingredient, Item>> modifiedDrops = new ArrayList<Map.Entry<Ingredient, Item>>();

        private Builder(BrokenBlockPredicate blockTarget) {
            this.blockTarget = blockTarget;
        }

        public Builder addModifiedDrop(Ingredient ingredient, Item item) {
            this.modifiedDrops.add(Map.entry(ingredient, item));
            return this;
        }

        public ModifyDropsResonanceProcessor build() {
            return new ModifyDropsResonanceProcessor(this.blockTarget, (Map<Ingredient, Item>)ImmutableMap.copyOf(this.modifiedDrops));
        }
    }
}

