/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.data_loaders.dimension;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.deeper_down.ColorGrading;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.conditions.ConditionalOps;

public class ColorGradingLoader
extends SimpleJsonResourceReloadListener {
    public static final ColorGradingLoader INSTANCE = new ColorGradingLoader();
    public static final Map<ResourceKey<Biome>, ColorGrading> DATA = new HashMap<ResourceKey<Biome>, ColorGrading>();
    public static final String ID = "color_grading";
    private static final Codec<ResourceKey<Biome>> KEY_CODEC = ResourceKey.codec((ResourceKey)Registries.BIOME);

    private ColorGradingLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<ResourceLocation, JsonElement> files, ResourceManager resourceManager, ProfilerFiller profiler) {
        DATA.clear();
        ConditionalOps ops = this.makeConditionalOps();
        files.forEach((path, parent) -> {
            JsonObject parentObject = parent.getAsJsonObject();
            boolean fallback = parentObject.get("default") != null;
            DataResult biome = KEY_CODEC.parse((DynamicOps)ops, (Object)parentObject.get("biome"));
            if (biome.error().isPresent() && !fallback) {
                ColorGradingLoader.error(path, biome);
                return;
            }
            DataResult data = ColorGrading.CODEC.parse((DynamicOps)ops, (Object)parentObject.getAsJsonObject(ID));
            if (data.error().isPresent()) {
                ColorGradingLoader.error(path, data);
            }
            if (fallback && data.result().isPresent()) {
                ColorGrading.DEFAULT = (ColorGrading)data.getOrThrow();
                return;
            }
            if (biome.result().isEmpty() || data.result().isEmpty()) {
                return;
            }
            DATA.put((ResourceKey<Biome>)((ResourceKey)biome.getOrThrow()), (ColorGrading)data.getOrThrow());
        });
    }

    private static void error(ResourceLocation path, DataResult<?> result) {
        PastelCommon.logError("Color Grading loading error [" + String.valueOf(path) + "]" + String.valueOf(result.error().get()));
    }
}

