/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.predicate.location.WorldConditionsPredicate;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;

public class EntityFishingDataLoader
extends SimpleJsonResourceReloadListener {
    public static final String ID = "entity_fishing";
    public static final EntityFishingDataLoader INSTANCE = new EntityFishingDataLoader();
    protected static final List<EntityFishingEntry> ENTITY_FISHING_ENTRIES = new ArrayList<EntityFishingEntry>();

    private EntityFishingDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        ENTITY_FISHING_ENTRIES.clear();
        prepared.forEach((identifier, jsonElement) -> CodecHelper.fromJson(EntityFishingEntry.CODEC, (JsonElement)jsonElement.getAsJsonObject()).ifPresent(ENTITY_FISHING_ENTRIES::add));
    }

    public static Optional<EntityFishingEntity> tryCatchEntity(ServerLevel world, BlockPos pos, int bigCatchLevel) {
        for (EntityFishingEntry entry : ENTITY_FISHING_ENTRIES) {
            Optional x;
            if (!entry.predicates.stream().anyMatch(p -> p.test(world, pos))) continue;
            if (world.random.nextFloat() < entry.entityChance * (float)(1 + bigCatchLevel) && (x = entry.weightedEntities.getRandom(world.random)).isPresent()) {
                return Optional.of((EntityFishingEntity)((WeightedEntry.Wrapper)x.get()).data());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public record EntityFishingEntry(List<WorldConditionsPredicate> predicates, float entityChance, WeightedRandomList<WeightedEntry.Wrapper<EntityFishingEntity>> weightedEntities) {
        public static final Codec<EntityFishingEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecHelper.singleOrList(WorldConditionsPredicate.CODEC).fieldOf("location").forGetter(EntityFishingEntry::predicates), (App)Codec.FLOAT.fieldOf("chance").forGetter(EntityFishingEntry::entityChance), (App)EntityFishingEntity.WEIGHTED_CODEC.listOf().xmap(WeightedRandomList::create, WeightedRandomList::unwrap).fieldOf("entities").forGetter(EntityFishingEntry::weightedEntities)).apply((Applicative)i, EntityFishingEntry::new));
    }

    public record EntityFishingEntity(Holder<EntityType<?>> entityType, CompoundTag nbt) {
        public static final MapCodec<EntityFishingEntity> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.ENTITY_TYPE.holderByNameCodec().fieldOf("id").forGetter(EntityFishingEntity::entityType), (App)CompoundTag.CODEC.optionalFieldOf("nbt", (Object)new CompoundTag()).forGetter(EntityFishingEntity::nbt)).apply((Applicative)i, EntityFishingEntity::new));
        public static final Codec<WeightedEntry.Wrapper<EntityFishingEntity>> WEIGHTED_CODEC = RecordCodecBuilder.create(i -> i.group((App)CODEC.forGetter(WeightedEntry.Wrapper::data), (App)Weight.CODEC.optionalFieldOf("id", (Object)Weight.of((int)1)).forGetter(WeightedEntry.Wrapper::weight)).apply((Applicative)i, WeightedEntry.Wrapper::new));
    }
}

