/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.page_types;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class WebLinkEntry
extends BookEntry {
    private final String url;

    public WebLinkEntry(ResourceLocation id, BookEntry.BookEntryData data, ResourceLocation commandToRunOnFirstReadId, String url) {
        super(id, data, commandToRunOnFirstReadId);
        this.url = url;
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.WEB_LINK_ENTRY_TYPE;
    }

    public void openEntry(BookAddress bookAddress) {
        ConfirmLinkScreen.confirmLinkNow((Screen)Minecraft.getInstance().screen, (String)this.url, (boolean)false);
    }

    public boolean matchesQuery(String query) {
        return false;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.id);
        this.data.toNetwork(buffer);
        buffer.writeNullable((Object)this.commandToRunOnFirstReadId, FriendlyByteBuf::writeResourceLocation);
        buffer.writeUtf(this.url);
    }

    public static WebLinkEntry fromNetwork(RegistryFriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork((RegistryFriendlyByteBuf)buffer);
        ResourceLocation commandToRunOnFirstReadId = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        String url = buffer.readUtf();
        return new WebLinkEntry(id, data, commandToRunOnFirstReadId, url);
    }

    public static WebLinkEntry fromJson(ResourceLocation id, JsonObject json, boolean autoAddReadConditions, HolderLookup.Provider wrapperLookup) {
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson((ResourceLocation)id, (JsonObject)json, (boolean)autoAddReadConditions, (HolderLookup.Provider)wrapperLookup);
        ResourceLocation commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        String url = GsonHelper.getAsString((JsonObject)json, (String)"url");
        return new WebLinkEntry(id, data, commandToRunOnFirstReadId, url);
    }
}

