/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import com.cmdpro.databank.DatabankUtils;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.api.recipe.DescriptiveGatedRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipeCategories;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;

public class PotionWorkshopReactingEmiRecipe
extends EmiInfoRecipe {
    private final DescriptiveGatedRecipe<?> recipe;

    public PotionWorkshopReactingEmiRecipe(DescriptiveGatedRecipe<?> recipe) {
        super(List.of(EmiStack.of((ItemLike)recipe.getItem())), List.of(recipe.getDescription()), EmiPort.getId(recipe));
        this.recipe = recipe;
    }

    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)PotionWorkshopRecipe.UNLOCK_IDENTIFIER) && DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)this.recipe.advancementID().orElse(null));
    }

    public EmiRecipeCategory getCategory() {
        return PastelEmiRecipeCategories.POTION_WORKSHOP_REACTING;
    }

    public int getDisplayHeight() {
        if (this.isUnlocked()) {
            return super.getDisplayHeight();
        }
        return 32;
    }

    public void addWidgets(WidgetHolder widgets) {
        if (!this.isUnlocked()) {
            widgets.addText(PastelEmiRecipe.HIDDEN_LINE_1, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 - 8, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
            widgets.addText(PastelEmiRecipe.HIDDEN_LINE_2, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 + 2, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
        } else {
            super.addWidgets(widgets);
        }
    }
}

