/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import com.cmdpro.databank.DatabankUtils;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipe;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.compress.utils.Lists;

public class PastelWorldInteractionRecipe
extends EmiWorldInteractionRecipe {
    private final List<ResourceLocation> requiredAdvancementIdentifier = Lists.newArrayList();

    protected PastelWorldInteractionRecipe(Builder builder) {
        super(builder.superbuilder);
        this.requiredAdvancementIdentifier.addAll(builder.requiredAdvancementIdentifier);
    }

    public static Builder customBuilder() {
        return new Builder();
    }

    public boolean hasAdvancement(ResourceLocation advancement) {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)advancement);
    }

    public boolean isUnlocked() {
        if (this.requiredAdvancementIdentifier.isEmpty()) {
            return true;
        }
        for (ResourceLocation id : this.requiredAdvancementIdentifier) {
            if (this.hasAdvancement(id)) continue;
            return false;
        }
        return true;
    }

    public int getDisplayWidth() {
        if (this.isUnlocked()) {
            return super.getDisplayWidth();
        }
        return 125;
    }

    public int getDisplayHeight() {
        if (this.isUnlocked()) {
            return super.getDisplayHeight();
        }
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        if (!this.isUnlocked()) {
            widgets.addText(PastelEmiRecipe.HIDDEN_LINE_1, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 - 9, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
            widgets.addText(PastelEmiRecipe.HIDDEN_LINE_2, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 + 1, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
        } else {
            super.addWidgets(widgets);
        }
    }

    public static class Builder {
        private final EmiWorldInteractionRecipe.Builder superbuilder;
        private final List<ResourceLocation> requiredAdvancementIdentifier = Lists.newArrayList();

        private Builder() {
            this.superbuilder = EmiWorldInteractionRecipe.builder();
        }

        public PastelWorldInteractionRecipe build() {
            return new PastelWorldInteractionRecipe(this);
        }

        public Builder id(ResourceLocation id) {
            this.superbuilder.id(id);
            return this;
        }

        public Builder leftInput(EmiIngredient stack) {
            this.superbuilder.leftInput(stack);
            return this;
        }

        public Builder leftInput(EmiIngredient stack, Function<SlotWidget, SlotWidget> mutator) {
            this.superbuilder.leftInput(stack, mutator);
            return this;
        }

        public Builder rightInput(EmiIngredient stack, boolean catalyst) {
            this.superbuilder.rightInput(stack, catalyst);
            return this;
        }

        public Builder rightInput(EmiIngredient stack, boolean catalyst, Function<SlotWidget, SlotWidget> mutator) {
            this.superbuilder.rightInput(stack, catalyst, mutator);
            return this;
        }

        public Builder output(EmiStack stack) {
            this.superbuilder.output(stack);
            return this;
        }

        public Builder output(EmiStack stack, Function<SlotWidget, SlotWidget> mutator) {
            this.superbuilder.output(stack, mutator);
            return this;
        }

        public Builder supportsRecipeTree(boolean supportsRecipeTree) {
            this.superbuilder.supportsRecipeTree(supportsRecipeTree);
            return this;
        }

        public Builder requiredAdvancement(ResourceLocation advId) {
            this.requiredAdvancementIdentifier.add(advId);
            return this;
        }
    }
}

