/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import com.cmdpro.databank.DatabankUtils;
import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.compat.emi.GatedSpectrumEmiRecipe;
import earth.terrarium.pastel.compat.emi.widgets.DynamicStackWidget;
import earth.terrarium.pastel.compat.emi.widgets.DynamicTextWidget;
import earth.terrarium.pastel.compat.emi.widgets.SaneButtonWidget;
import earth.terrarium.pastel.items.magic_items.KnowledgeGemItem;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.recipe.RecipeScaling;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;

public class EnchantmentUpgradeEmiRecipeGated
extends GatedSpectrumEmiRecipe<GatedPastelRecipe<?>> {
    private static final ResourceLocation BACKGROUND_TEXTURE = PastelCommon.locate("textures/gui/container/enchanter.png");
    private static final int NORMAL_COLOR = 5060181;
    private static final int OVERCHANT_COLOR = 14366052;
    private static final int SWITCH_TIME = 30;
    private static final int XP_INDEX = 8;
    private static final int BOOK_INDEXES_START = 9;
    private final Component transKey;
    private final int levelCap;
    private final int maxNormal;
    private final RecipeScaling.ScalingData itemScaling;
    private final RecipeScaling.ScalingData xpScaling;
    private int indexer = 1;

    public EnchantmentUpgradeEmiRecipeGated(EmiRecipeCategory category, EnchantmentUpgradeRecipe recipe) {
        super(category, recipe, 132, 90);
        int i;
        this.itemScaling = recipe.getItemScaling();
        this.xpScaling = recipe.getXpScaling();
        this.inputs = Lists.newArrayList();
        Holder<Enchantment> enchant = recipe.getEnchantment();
        this.levelCap = recipe.getLevelCap();
        this.maxNormal = ((Enchantment)enchant.value()).getMaxLevel();
        this.transKey = ((Enchantment)enchant.value()).description().copy().withStyle(s -> s.withItalic(Boolean.valueOf(true)));
        for (i = 0; i < 8; ++i) {
            this.inputs.add(EmiStack.of((ItemLike)recipe.getBulkItem(), (long)1L));
        }
        this.inputs.add(EmiStack.of((ItemStack)KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getBaseXPCost(), true)));
        this.outputs = new ArrayList();
        for (i = 1; i <= this.levelCap; ++i) {
            ItemStack enchStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            builder.set(enchant, i);
            enchStack.set(DataComponents.STORED_ENCHANTMENTS, (Object)builder.toImmutable());
            this.inputs.add(EmiStack.of((ItemStack)enchStack.copy()));
            if (i <= 1) continue;
            enchStack.set(DataComponents.STORED_ENCHANTMENTS, (Object)builder.toImmutable());
            this.outputs.add(EmiStack.of((ItemStack)enchStack));
        }
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        boolean overEnchant = DatabankUtils.hasAdvancement((Player)Minecraft.getInstance().player, (ResourceLocation)PastelAdvancements.OVERENCHANTING);
        this.indexer = 1;
        widgets.addTexture(BACKGROUND_TEXTURE, 13, 13, 54, 54, 0, 0);
        if (overEnchant && this.levelCap > this.maxNormal) {
            widgets.addTexture(BACKGROUND_TEXTURE, 0, 0, 16, 16, 64, 0).tooltipText(List.of(Component.translatable((String)"container.pastel.rei.enchantment_upgrade.tooltip").withStyle(s -> s.withColor(14366052))));
        }
        DynamicStackWidget gem = new DynamicStackWidget(c -> {
            int xp = this.xpScaling.apply(this.indexer);
            return EmiStack.of((ItemStack)KnowledgeGemItem.getKnowledgeDropStackWithXP(xp, false));
        }, 0, 111, 5);
        widgets.add((Widget)gem);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.ENCHANTER.get())), 111, 51).drawBack(false);
        int cap = overEnchant ? this.levelCap : this.maxNormal;
        SaneButtonWidget minus = (SaneButtonWidget)((Object)new SaneButtonWidget(84, 18, 8, 8, 64, 16, BACKGROUND_TEXTURE, () -> false, (mX, mY, b) -> {
            this.indexer = Math.clamp((long)(this.indexer - 1), 1, cap - 1);
        }).tooltipText(List.of(Component.translatable((String)"container.pastel.rei.enchantment_upgrade.button"))));
        SaneButtonWidget plus = (SaneButtonWidget)((Object)new SaneButtonWidget(94, 18, 8, 8, 72, 16, BACKGROUND_TEXTURE, () -> false, (mX, mY, b) -> {
            this.indexer = Math.clamp((long)(this.indexer + 1), 1, cap - 1);
        }).tooltipText(List.of(Component.translatable((String)"container.pastel.rei.enchantment_upgrade.button"))));
        widgets.add((Widget)minus);
        widgets.add((Widget)plus);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 18, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 44, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), 62, 18);
        widgets.addSlot((EmiIngredient)this.inputs.get(3), 62, 44);
        widgets.addSlot((EmiIngredient)this.inputs.get(4), 44, 62);
        widgets.addSlot((EmiIngredient)this.inputs.get(5), 18, 62);
        widgets.addSlot((EmiIngredient)this.inputs.get(6), 0, 44);
        widgets.addSlot((EmiIngredient)this.inputs.get(7), 0, 18);
        DynamicStackWidget in = new DynamicStackWidget(c -> (EmiIngredient)this.inputs.get(9 + this.indexer - 1), 0, 31, 31);
        widgets.add((Widget)in);
        DynamicStackWidget out = new DynamicStackWidget(c -> (EmiIngredient)this.inputs.get(9 + this.indexer), 0, 106, 26);
        out.large(true).recipeContext((EmiRecipe)this);
        widgets.add((Widget)out);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 80, 31);
        DynamicTextWidget lv = new DynamicTextWidget(c -> {
            int color = 5060181;
            if (this.indexer + 1 > this.maxNormal) {
                color = 14366052;
            }
            return new Tuple((Object)Component.translatable((String)"container.pastel.rei.enchantment_upgrade.level", (Object[])new Object[]{this.indexer, this.indexer + 1}).getVisualOrderText(), (Object)color);
        }, 67, 2, false);
        widgets.add((Widget)lv);
        DynamicTextWidget itemUse = new DynamicTextWidget(c -> new Tuple((Object)Component.translatable((String)"container.pastel.rei.enchantment_upgrade.required_item_count", (Object[])new Object[]{this.itemScaling.apply(this.indexer)}).getVisualOrderText(), (Object)5060181), 67, 70, false);
        widgets.add((Widget)itemUse);
        widgets.addText(this.transKey, 3, 82, 5060181, false);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return super.getOutputs();
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return super.getInputs();
    }
}

