/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipe;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class GatedSpectrumEmiRecipe<T extends GatedRecipe<?>>
extends PastelEmiRecipe {
    public static final Component SECRET = Component.translatable((String)"container.pastel.rei.pedestal_crafting.secret_recipe");
    public static final Component SECRET_HINT = Component.translatable((String)"container.pastel.rei.pedestal_crafting.secret_recipe.hint");
    @Nullable
    public final Component secretHintText;
    public final T recipe;

    public GatedSpectrumEmiRecipe(EmiRecipeCategory category, T recipe, int width, int height) {
        super(category, recipe.typeAdvancementID(), EmiPort.getId(recipe), width, height);
        this.recipe = recipe;
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)this.getRegistryManager())));
        this.secretHintText = recipe.getSecretHintText(this.getId());
    }

    @Override
    public boolean isUnlocked() {
        if (!super.isUnlocked()) {
            return false;
        }
        return this.recipe.advancementID().map(this::hasAdvancement).orElse(true);
    }

    public boolean hideCraftable() {
        return this.recipe.isSecret() || super.hideCraftable();
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        if (this.recipe.isSecret() && this.isUnlocked()) {
            if (this.secretHintText == null) {
                widgets.addText(SECRET, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
            } else {
                widgets.addText(SECRET_HINT, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 - 8, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
                widgets.addText(this.secretHintText, this.getDisplayWidth() / 2, this.getDisplayHeight() / 2 + 2, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
            }
        } else {
            super.addWidgets(widgets);
        }
    }
}

