/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.create;

import com.simibubi.create.api.event.PipeCollisionEvent;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.blocks.crystallarieum.PastelClusterBlock;
import earth.terrarium.pastel.blocks.fluid.PastelFluidBlock;
import earth.terrarium.pastel.compat.PastelIntegrationPacks;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.client.PastelModels;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class CreateCompat
extends PastelIntegrationPacks.ModIntegrationPack {
    public static DeferredBlock<Block> SMALL_ZINC_BUD = PastelBlocks.register(PastelBlocks.cluster(PastelBlocks.blockWithItem("small_zinc_bud", () -> new PastelClusterBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).destroyTime(1.0f).mapColor(Blocks.LIGHT_GRAY_CONCRETE.defaultMapColor()).requiresCorrectToolForDrops().noOcclusion(), PastelClusterBlock.GrowthStage.SMALL), InkColors.BROWN), ModelTemplates.CROSS));
    public static DeferredBlock<Block> LARGE_ZINC_BUD = PastelBlocks.register(PastelBlocks.cluster(PastelBlocks.blockWithItem("large_zinc_bud", () -> new PastelClusterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMALL_ZINC_BUD.get())), PastelClusterBlock.GrowthStage.LARGE), InkColors.BROWN), PastelModels.CRYSTALLARIEUM_FARMABLE));
    public static DeferredBlock<Block> ZINC_CLUSTER = PastelBlocks.register(PastelBlocks.cluster(PastelBlocks.blockWithItem("zinc_cluster", () -> new PastelClusterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMALL_ZINC_BUD.get())), PastelClusterBlock.GrowthStage.CLUSTER), InkColors.BROWN), PastelModels.CRYSTALLARIEUM_FARMABLE));
    public static DeferredBlock<Block> PURE_ZINC_BLOCK = PastelBlocks.register(PastelBlocks.simple(PastelBlocks.blockWithItem("pure_zinc_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)), InkColors.BROWN)));
    public static DeferredItem<Item> PURE_ZINC = PastelItems.register(PastelItems.simple(PastelItems.item("pure_zinc", () -> new Item(PastelItems.IS.of()), InkColors.BROWN)));

    @Override
    public void register() {
        NeoForge.EVENT_BUS.addListener(CreateCompat::onPipeSpillCollision);
        NeoForge.EVENT_BUS.addListener(CreateCompat::onPipeFlowCollision);
    }

    private static void onPipeFlowCollision(PipeCollisionEvent.Flow event) {
        BlockState result = CreateCompat.handleBidirectionalCollision(event.getLevel(), event.getFirstFluid(), event.getSecondFluid());
        if (result != null) {
            event.setState(result);
        }
    }

    private static void onPipeSpillCollision(PipeCollisionEvent.Spill event) {
        BlockState result = CreateCompat.handleBidirectionalCollision(event.getLevel(), event.getPipeFluid(), event.getWorldFluid());
        if (result != null) {
            event.setState(result);
        }
    }

    private static BlockState handleBidirectionalCollision(Level world, @NotNull Fluid firstFluid, @NotNull Fluid secondFluid) {
        FluidState secondState;
        FluidState firstState = firstFluid.defaultFluidState();
        BlockState result = CreateCompat.spectrumFluidCollision(world, firstState, secondState = secondFluid.defaultFluidState());
        if (result != null) {
            return result;
        }
        return CreateCompat.spectrumFluidCollision(world, secondState, firstState);
    }

    private static BlockState spectrumFluidCollision(Level world, FluidState state, FluidState otherState) {
        Block block = state.createLegacyBlock().getBlock();
        if (block instanceof PastelFluidBlock) {
            PastelFluidBlock spectrumFluid = (PastelFluidBlock)block;
            return spectrumFluid.handleFluidCollision(world, state, otherState);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }
}

