/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.compat.REI.FluidIngredientREI;
import earth.terrarium.pastel.compat.REI.PastelDisplay;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.REIHelper;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.recipe.titration_barrel.ITitrationBarrelRecipe;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class TitrationBarrelDisplay
extends PastelDisplay {
    protected final EntryIngredient tappingIngredient;
    protected final int minFermentationTimeHours;
    protected final FermentationData fermentationData;

    public TitrationBarrelDisplay(@NotNull RecipeHolder<ITitrationBarrelRecipe> recipe) {
        super(recipe, TitrationBarrelDisplay.buildInputs((ITitrationBarrelRecipe)recipe.value()), List.of(TitrationBarrelDisplay.buildOutputs((ITitrationBarrelRecipe)recipe.value())));
        this.tappingIngredient = ((ITitrationBarrelRecipe)recipe.value()).getTappingItem() == Items.AIR ? EntryIngredient.empty() : EntryIngredients.of((ItemStack)((ITitrationBarrelRecipe)recipe.value()).getTappingItem().getDefaultInstance());
        this.minFermentationTimeHours = ((ITitrationBarrelRecipe)recipe.value()).getMinFermentationTimeHours();
        this.fermentationData = ((ITitrationBarrelRecipe)recipe.value()).getFermentationData();
    }

    private static EntryIngredient buildOutputs(ITitrationBarrelRecipe recipe) {
        TitrationBarrelRecipe titrationBarrelRecipe;
        if (recipe instanceof TitrationBarrelRecipe && (titrationBarrelRecipe = (TitrationBarrelRecipe)recipe).getFermentationData() != null) {
            return EntryIngredients.ofItemStacks(titrationBarrelRecipe.getOutputVariations(TitrationBarrelRecipe.FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS));
        }
        return EntryIngredients.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess()));
    }

    public static List<EntryIngredient> buildInputs(ITitrationBarrelRecipe recipe) {
        List<EntryIngredient> inputs = REIHelper.toEntryIngredients(recipe.getIngredientStacks());
        if (!recipe.getFluidInput().isEmpty()) {
            inputs.add(FluidIngredientREI.into(recipe.getFluidInput()));
        }
        return inputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PastelPlugins.TITRATION_BARREL;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)TitrationBarrelRecipe.UNLOCK_ADVANCEMENT_IDENTIFIER) && super.isUnlocked();
    }
}

