/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.GatedDisplayCategory;
import earth.terrarium.pastel.compat.REI.plugins.TitrationBarrelDisplay;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TitrationBarrelCategory
extends GatedDisplayCategory<TitrationBarrelDisplay> {
    public CategoryIdentifier<TitrationBarrelDisplay> getCategoryIdentifier() {
        return PastelPlugins.TITRATION_BARREL;
    }

    public Component getTitle() {
        return ((Block)PastelBlocks.TITRATION_BARREL.get()).getName();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)PastelBlocks.TITRATION_BARREL.get()));
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull TitrationBarrelDisplay display) {
        List inputs = display.getInputEntries();
        int ingredientSize = inputs.size();
        int startX = startPoint.x + Math.max(-5, 15 - ingredientSize * 10);
        int startY = startPoint.y + (ingredientSize > 3 ? 1 : 11);
        for (int i = 0; i < ingredientSize; ++i) {
            int yOffset;
            int xOffset;
            EntryIngredient currentIngredient = (EntryIngredient)inputs.get(i);
            if (i < 3) {
                xOffset = i * 20;
                yOffset = 0;
            } else {
                xOffset = (i - 3) * 20;
                yOffset = 20;
            }
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + xOffset, startY + yOffset)).markInput().entries((Collection)currentIngredient));
        }
        if (display.tappingIngredient.isEmpty()) {
            widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 11)).animationDurationTicks((double)(display.minFermentationTimeHours * 20)));
        } else {
            widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 3)).animationDurationTicks((double)(display.minFermentationTimeHours * 20)));
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 64, startPoint.y + 21)).markInput().entries((Collection)display.tappingIngredient));
        }
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y + 11)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 11)).markOutput().disableBackground().entries((Collection)display.getOutputEntries().get(0)));
        MutableComponent text = TitrationBarrelRecipe.getDurationText(display.minFermentationTimeHours, display.fermentationData);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x - 10, startPoint.y + 42), (Component)text).leftAligned().color(0x3F3F3F).noShadow());
    }

    public int getDisplayHeight() {
        return 59;
    }
}

