/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.google.common.collect.Lists;
import earth.terrarium.pastel.compat.REI.GatedRecipeDisplay;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class GatedDisplayCategory<T extends GatedRecipeDisplay>
implements DisplayCategory<T> {
    public static final Component HIDDEN_LINE_1 = Component.translatable((String)"container.pastel.rei.pedestal_crafting.recipe_not_unlocked_line_1");
    public static final Component HIDDEN_LINE_2 = Component.translatable((String)"container.pastel.rei.pedestal_crafting.recipe_not_unlocked_line_2");
    public static final Component SECRET = Component.translatable((String)"container.pastel.rei.pedestal_crafting.secret_recipe");
    public static final Component SECRET_HINT = Component.translatable((String)"container.pastel.rei.pedestal_crafting.secret_recipe.hint");

    public List<Widget> setupDisplay(@NotNull T display, @NotNull Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - this.getDisplayHeight() / 2 + 5);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        if (display.isUnlocked()) {
            if (display.isSecret()) {
                if (display.getSecretHintText() == null) {
                    widgets.add(Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() - 9), (Component)SECRET).centered().color(0x3F3F3F).noShadow());
                } else {
                    widgets.add(Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() - 9), (Component)SECRET_HINT).centered().color(0x3F3F3F).noShadow());
                    widgets.add(Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() + 1), (Component)display.getSecretHintText()).centered().color(0x3F3F3F).noShadow());
                }
            } else {
                this.setupWidgets(startPoint, bounds, widgets, display);
            }
        } else {
            widgets.add(Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() - 9), (Component)HIDDEN_LINE_1).centered().color(0x3F3F3F).noShadow());
            widgets.add(Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() + 1), (Component)HIDDEN_LINE_2).centered().color(0x3F3F3F).noShadow());
        }
        return widgets;
    }

    public abstract void setupWidgets(Point var1, Rectangle var2, List<Widget> var3, @NotNull T var4);

    protected static Component getCraftingTimeText(int time) {
        if (time == 20) {
            return Component.translatable((String)"container.pastel.rei.crafting_time_one_second", (Object[])new Object[]{1});
        }
        return Component.translatable((String)"container.pastel.rei.crafting_time", (Object[])new Object[]{time / 20});
    }

    protected static Component getCraftingTimeText(int time, float xp) {
        if (time == 20) {
            return Component.translatable((String)"container.pastel.rei.crafting_time_one_second_and_xp", (Object[])new Object[]{1, Float.valueOf(xp)});
        }
        return Component.translatable((String)"container.pastel.rei.crafting_time_and_xp", (Object[])new Object[]{time / 20, Float.valueOf(xp)});
    }
}

