/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.AnvilCrushingDisplay;
import earth.terrarium.pastel.compat.REI.plugins.GatedDisplayCategory;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AnvilCrushingCategory
extends GatedDisplayCategory<AnvilCrushingDisplay> {
    private static final ResourceLocation WALL_TEXTURE = PastelCommon.locate("textures/gui/container/anvil_crushing.png");
    private static final EntryIngredient ANVIL = EntryIngredients.of((ItemLike)Items.ANVIL);

    public CategoryIdentifier<AnvilCrushingDisplay> getCategoryIdentifier() {
        return PastelPlugins.ANVIL_CRUSHING;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.pastel.rei.anvil_crushing.title");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.ANVIL);
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull AnvilCrushingDisplay display) {
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 50, startPoint.y - 8 + 23)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y - 8 + 24)));
        List input = display.getInputEntries();
        List output = display.getOutputEntries();
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 20, startPoint.y - 8 + 18)).entries((Collection)ANVIL).disableBackground().notInteractable());
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 20, startPoint.y - 8 + 40)).markInput().entries((Collection)input.get(0)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y - 8 + 23)).markOutput().disableBackground().entries((Collection)output.get(0)));
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)WALL_TEXTURE, (int)startPoint.x, (int)(startPoint.y - 8 + 9), (float)0.0f, (float)0.0f, (int)16, (int)48));
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)WALL_TEXTURE, (int)(startPoint.x + 20), (int)(startPoint.y - 8 + 8), (float)16.0f, (float)0.0f, (int)16, (int)16));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x + 84, startPoint.y - 8 + 48), (Component)Component.translatable((String)"container.pastel.rei.anvil_crushing.plus_xp", (Object[])new Object[]{Float.valueOf(display.experience)})).leftAligned().color(0x3F3F3F).noShadow());
        MutableComponent text = display.crushedItemsPerPointOfDamage >= 1.0f ? Component.translatable((String)"container.pastel.rei.anvil_crushing.low_force_required") : ((double)display.crushedItemsPerPointOfDamage >= 0.5 ? Component.translatable((String)"container.pastel.rei.anvil_crushing.medium_force_required") : Component.translatable((String)"container.pastel.rei.anvil_crushing.high_force_required"));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y - 10 + 64), (Component)text).leftAligned().color(0x3F3F3F).noShadow());
    }

    public int getDisplayHeight() {
        return 72;
    }
}

