/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.compat.REI.GatedRecipeDisplay;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public abstract class PastelDisplay
extends BasicDisplay
implements GatedRecipeDisplay {
    private final ResourceLocation requiredAdvancementIdentifier;
    private final boolean secret;
    @Nullable
    private final Component secretHintText;

    public PastelDisplay(RecipeHolder<? extends GatedRecipe<?>> recipe, Ingredient input, ItemStack output) {
        this(recipe, Collections.singletonList(EntryIngredients.ofIngredient((Ingredient)input)), Collections.singletonList(EntryIngredients.of((ItemStack)output)));
    }

    public PastelDisplay(RecipeHolder<? extends GatedRecipe<?>> recipe, List<EntryIngredient> inputs, ItemStack output) {
        this(recipe, inputs, Collections.singletonList(EntryIngredients.of((ItemStack)output)));
    }

    public PastelDisplay(RecipeHolder<? extends GatedRecipe<?>> recipe, List<EntryIngredient> inputs, List<EntryIngredient> outputs) {
        super(inputs, outputs);
        this.secret = ((GatedRecipe)recipe.value()).isSecret();
        this.requiredAdvancementIdentifier = ((GatedRecipe)recipe.value()).advancementID().orElse(null);
        this.secretHintText = null;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        if (client.player == null || this.requiredAdvancementIdentifier == null) {
            return true;
        }
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)this.requiredAdvancementIdentifier);
    }

    @Override
    public boolean isSecret() {
        return this.secret;
    }

    @Override
    @Nullable
    public Component getSecretHintText() {
        return this.secretHintText;
    }
}

