/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.commands;

import com.cmdpro.databank.advancement.criteria.HasAdvancementCriteria;
import com.cmdpro.databank.advancement.criteria.HasAdvancementsCriteria;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenCondition;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.cmdpro.databank.hidden.conditions.AdvancementCondition;
import com.cmdpro.databank.registry.HiddenTypeRegistry;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.color.ColorRegistry;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.blocks.PlacedItemBlock;
import earth.terrarium.pastel.blocks.deeper_down.flora.WeepingGalaFrondsBlock;
import earth.terrarium.pastel.blocks.gemstone.PastelBuddingBlock;
import earth.terrarium.pastel.items.PigmentItem;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.recipe.anvil_crushing.AnvilCrushingRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchanterRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.commons.lang3.StringUtils;

public class SanityCommand {
    private static final ResourceLocation WIP_ADVANCEMENT_ID = PastelCommon.locate("__wip");
    private static final List<ResourceLocation> ADVANCEMENT_GATING_WARNING_WHITELIST = List.of(PastelCommon.locate("find_preservation_ruins"), PastelCommon.locate("fail_to_glitch_into_preservation_ruin"), PastelCommon.locate("midgame/craft_blacklisted_memory_success"), PastelCommon.locate("lategame/collect_myceylon"), PastelCommon.locate("lategame/strike_up_hummingstone_hymn"));
    private static final List<ResourceLocation> GUIDEBOOK_WARNING_WHITELIST = List.of(PastelCommon.locate("cuisine/cookbooks/brewers_handbook"));

    public static void register(LiteralCommandNode<CommandSourceStack> root) {
        LiteralCommandNode sanity = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sanity").requires(source -> source.hasPermission(2))).executes(context -> SanityCommand.execute((CommandSourceStack)context.getSource(), "pastel"))).build();
        ArgumentCommandNode modId = ((RequiredArgumentBuilder)Commands.argument((String)"mod_id", (ArgumentType)StringArgumentType.word()).executes(context -> SanityCommand.execute((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"mod_id")))).build();
        sanity.addChild((CommandNode)modId);
        root.addChild((CommandNode)sanity);
    }

    private static int execute(CommandSourceStack source, String modId) {
        Object id;
        Holder entry;
        ItemEnchantments enchantments;
        ItemStack output;
        EnchanterRecipe recipe;
        ResourceKey registryKey;
        RegistryAccess registryManager = source.registryAccess();
        PastelCommon.logInfo("##### SANITY CHECK START ######");
        for (Map.Entry entry2 : BuiltInRegistries.BLOCK.entrySet()) {
            BlockState blockState;
            registryKey = (ResourceKey)entry2.getKey();
            if (!registryKey.location().getNamespace().equals(modId) || (blockState = ((Block)entry2.getValue()).defaultBlockState()).getBlock().defaultDestroyTime() <= 0.0f || blockState.is(BlockTags.MINEABLE_WITH_PICKAXE) || blockState.is(BlockTags.MINEABLE_WITH_AXE) || blockState.is(BlockTags.MINEABLE_WITH_SHOVEL) || blockState.is(BlockTags.MINEABLE_WITH_HOE) || blockState.is(BlockTags.SWORD_EFFICIENT) || blockState.is(PastelBlockTags.EXEMPT_FROM_MINEABLE_DEBUG_CHECK)) continue;
            PastelCommon.logWarning("[SANITY: Mineable Tags] Block " + String.valueOf(registryKey.location()) + " is not contained in a any vanilla mineable tag.");
        }
        for (Map.Entry entry3 : BuiltInRegistries.BLOCK.entrySet()) {
            Block block;
            registryKey = (ResourceKey)entry3.getKey();
            if (!registryKey.location().getNamespace().equals(modId) || (block = (Block)entry3.getValue()) instanceof PlacedItemBlock || block instanceof PastelBuddingBlock || block instanceof WeepingGalaFrondsBlock) continue;
            BlockState blockState = ((Block)entry3.getValue()).defaultBlockState();
            ResourceKey lootTableKey = block.getLootTable();
            ResourceLocation resourceLocation = lootTableKey.location();
            if (blockState.getBlock().defaultDestroyTime() <= -1.0f || blockState.is(PastelBlockTags.EXEMPT_FROM_LOOT_TABLE_DEBUG_CHECK)) continue;
            if (lootTableKey.equals(BuiltInLootTables.EMPTY) || resourceLocation.getPath().equals("blocks/air")) {
                PastelCommon.logWarning("[SANITY: Loot Tables] Block " + String.valueOf(registryKey.location()) + " has a non-existent loot table (" + String.valueOf(resourceLocation) + ")");
                continue;
            }
            LootTable lootTable = source.getLevel().getServer().reloadableRegistries().getLootTable(lootTableKey);
            List lootPools = lootTable.pools;
            if (!lootPools.isEmpty()) continue;
            PastelCommon.logWarning("[SANITY: Loot Tables] Block " + String.valueOf(registryKey.location()) + " has an empty loot table");
        }
        HashMap usedColorsForEachTier = new HashMap();
        for (PedestalTier pedestalRecipeTier : PedestalTier.values()) {
            HashMap<PastelGemstoneColor, Integer> colorMap = new HashMap<PastelGemstoneColor, Integer>();
            for (PastelGemstoneColor gemstoneColor : PastelGemstoneColor.values()) {
                colorMap.put(gemstoneColor, 0);
            }
            usedColorsForEachTier.put((Object)((Object)pedestalRecipeTier), colorMap);
        }
        MinecraftServer minecraftServer = source.getLevel().getServer();
        RecipeManager recipeManager = minecraftServer.getRecipeManager();
        ServerAdvancementManager advancementLoader = minecraftServer.getAdvancements();
        for (RecipeHolder pedestalRecipeEntry : recipeManager.getAllRecipesFor(PastelRecipeTypes.PEDESTAL)) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)pedestalRecipeEntry.value();
            if ((pedestalRecipe.getTier() == PedestalTier.BASIC || pedestalRecipe.getTier() == PedestalTier.SIMPLE) && pedestalRecipe.getPowderInputs().getOrDefault(PastelGemstoneColor.BLACK, 0) > 0) {
                PastelCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + String.valueOf(pedestalRecipeEntry.id()) + "' of tier '" + String.valueOf((Object)pedestalRecipe.getTier()) + "' is using onyx powder as input! Players will not have access to Onyx at that tier");
            }
            if (pedestalRecipe.getTier() != PedestalTier.COMPLEX && pedestalRecipe.getPowderInputs().getOrDefault(PastelGemstoneColor.WHITE, 0) > 0) {
                PastelCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + String.valueOf(pedestalRecipeEntry.id()) + "' of tier '" + String.valueOf((Object)pedestalRecipe.getTier()) + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
            }
            for (Map.Entry<GemstoneColor, Integer> powderInput : pedestalRecipe.getPowderInputs().entrySet()) {
                ((Map)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).put(powderInput.getKey(), (Integer)((Map)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).get(powderInput.getKey()) + powderInput.getValue());
            }
        }
        for (Map.Entry item : BuiltInRegistries.ITEM.entrySet()) {
            if (!((ResourceKey)item.getKey()).location().getNamespace().equals(modId) || Language.getInstance().has(((Item)item.getValue()).getDescriptionId())) continue;
            PastelCommon.logWarning("[SANITY: Item Lang] Missing translation string " + ((Item)item.getValue()).getDescriptionId());
        }
        for (Map.Entry block : BuiltInRegistries.BLOCK.entrySet()) {
            if (!((ResourceKey)block.getKey()).location().getNamespace().equals(modId) || Language.getInstance().has(((Block)block.getValue()).getDescriptionId())) continue;
            PastelCommon.logWarning("[SANITY: Block Lang] Missing translation string " + ((Block)block.getValue()).getDescriptionId());
        }
        for (Object entityType : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            if (!((ResourceKey)entityType.getKey()).location().getNamespace().equals(modId) || Language.getInstance().has(((EntityType)entityType.getValue()).getDescriptionId())) continue;
            PastelCommon.logWarning("[SANITY: EntityType Lang] Missing translation string " + ((EntityType)entityType.getValue()).getDescriptionId());
        }
        for (Object entityType : BuiltInRegistries.MOB_EFFECT.entrySet()) {
            if (!((ResourceKey)entityType.getKey()).location().getNamespace().equals(modId) || Language.getInstance().has(((MobEffect)entityType.getValue()).getDescriptionId())) continue;
            PastelCommon.logWarning("[SANITY: Status Effect Lang] Missing translation string " + ((MobEffect)entityType.getValue()).getDescriptionId());
        }
        for (Object entityType : BuiltInRegistries.ATTRIBUTE.entrySet()) {
            if (!((ResourceKey)entityType.getKey()).location().getNamespace().equals(modId) || Language.getInstance().has(((Attribute)entityType.getValue()).getDescriptionId())) continue;
            PastelCommon.logWarning("[SANITY: Attribute Lang] Missing translation string " + ((Attribute)entityType.getValue()).getDescriptionId());
        }
        for (Object entityType : BuiltInRegistries.ATTRIBUTE.entrySet()) {
            if (!((ResourceKey)entityType.getKey()).location().getNamespace().equals(modId)) continue;
            if (!Language.getInstance().has(((Attribute)entityType.getValue()).getDescriptionId())) {
                PastelCommon.logWarning("[SANITY: Attribute Lang] Missing translation string " + ((Attribute)entityType.getValue()).getDescriptionId());
            }
            if (Language.getInstance().has(((Attribute)entityType.getValue()).getDescriptionId() + ".desc")) continue;
            PastelCommon.logWarning("[SANITY: Attribute Lang] Missing description string " + ((Attribute)entityType.getValue()).getDescriptionId() + ".desc");
        }
        HashSet recipeGroups = new HashSet();
        recipeManager.getRecipeIds().forEach(identifier -> {
            Recipe patt0$temp;
            Optional recipe = recipeManager.byKey(identifier);
            if (recipe.isPresent() && (patt0$temp = ((RecipeHolder)recipe.get()).value()) instanceof GatedPastelRecipe) {
                GatedPastelRecipe gatedSpectrumRecipe = (GatedPastelRecipe)patt0$temp;
                String group = gatedSpectrumRecipe.getGroup();
                if (group == null) {
                    PastelCommon.logWarning("Recipe with null group found! :" + gatedSpectrumRecipe.getGroup());
                } else if (!group.isEmpty()) {
                    recipeGroups.add(group);
                }
            }
        });
        for (String string : recipeGroups) {
            if (Language.getInstance().has("recipeGroup.pastel." + string)) continue;
            PastelCommon.logWarning("[SANITY: Recipe Group Lang] Recipe group " + string + " is not localized.");
        }
        for (RecipeHolder recipeHolder : recipeManager.getRecipes()) {
            GatedRecipe gatedRecipe;
            Optional<ResourceLocation> advancementIdentifier;
            Recipe powderInput = recipeHolder.value();
            if (!(powderInput instanceof GatedRecipe) || !(advancementIdentifier = (gatedRecipe = (GatedRecipe)powderInput).advancementID()).isPresent() || advancementLoader.get(advancementIdentifier.get()) != null) continue;
            PastelCommon.logWarning("[SANITY: " + gatedRecipe.getRecipeTypeShortID() + " Recipe Unlocks] Advancement '" + String.valueOf(gatedRecipe.advancementID()) + "' in recipe '" + String.valueOf(recipeHolder.id()) + "' does not exist");
        }
        SanityCommand.testIngredientsAndOutputInColorRegistry(PastelRecipeTypes.FUSION_SHRINE, "Fusion Shrine", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(PastelRecipeTypes.ENCHANTER, "Enchanting", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(PastelRecipeTypes.ENCHANTMENT_UPGRADE, "Enchantment Upgrade", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(PastelRecipeTypes.SPIRIT_INSTILLING, "Spirit Instiller", recipeManager, registryManager);
        for (Map.Entry entry4 : ((HiddenTypeInstance.HiddenType)HiddenTypeRegistry.BLOCK.get()).getHiddenOfType().entrySet()) {
            HiddenCondition advancementIdentifier = ((Hidden)entry4.getValue()).condition;
            if (!(advancementIdentifier instanceof AdvancementCondition)) continue;
            AdvancementCondition condition = (AdvancementCondition)advancementIdentifier;
            if (advancementLoader.get(condition.advancement.location()) != null) continue;
            PastelCommon.logWarning("[SANITY: Block Cloaks] Advancement '" + String.valueOf(condition.advancement.location()) + "' for block cloaking does not exist. Registered cloak: " + String.valueOf(entry4.getKey()));
        }
        for (Map.Entry entry5 : ((HiddenTypeInstance.HiddenType)HiddenTypeRegistry.ITEM.get()).getHiddenOfType().entrySet()) {
            HiddenCondition advancementIdentifier = ((Hidden)entry5.getValue()).condition;
            if (!(advancementIdentifier instanceof AdvancementCondition)) continue;
            AdvancementCondition condition = (AdvancementCondition)advancementIdentifier;
            if (advancementLoader.get(condition.advancement.location()) != null) continue;
            PastelCommon.logWarning("[SANITY: Item Cloaks] Advancement '" + String.valueOf(condition.advancement.location()) + "' for item cloaking does not exist. Registered cloaks: " + String.valueOf(entry5.getKey()));
        }
        for (AdvancementHolder advancementHolder : advancementLoader.getAllAdvancements()) {
            Advancement advancement = advancementHolder.value();
            for (Criterion criterion : advancement.criteria().values()) {
                CriterionTriggerInstance conditions = criterion.triggerInstance();
                if (conditions instanceof HasAdvancementCriteria.HasAdvancementCriteriaInstance) {
                    AdvancementHolder advancementCriterionAdvancement;
                    HasAdvancementCriteria.HasAdvancementCriteriaInstance hasAdvancementConditions = (HasAdvancementCriteria.HasAdvancementCriteriaInstance)conditions;
                    ResourceLocation advancementIdentifier = hasAdvancementConditions.advancement();
                    if (advancementIdentifier.equals((Object)WIP_ADVANCEMENT_ID) || (advancementCriterionAdvancement = advancementLoader.get(advancementIdentifier)) != null) continue;
                    PastelCommon.logWarning("[SANITY: Has_Advancement Criteria] Advancement '" + String.valueOf(advancementHolder.id()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
                    continue;
                }
                if (!(conditions instanceof HasAdvancementsCriteria.HasAdvancementsCriteriaInstance)) continue;
                HasAdvancementsCriteria.HasAdvancementsCriteriaInstance hasAdvancementConditions = (HasAdvancementsCriteria.HasAdvancementsCriteriaInstance)conditions;
                for (ResourceLocation advancementIdentifier : hasAdvancementConditions.advancements()) {
                    AdvancementHolder advancementCriterionAdvancement;
                    if (advancementIdentifier.equals((Object)WIP_ADVANCEMENT_ID) || (advancementCriterionAdvancement = advancementLoader.get(advancementIdentifier)) != null) continue;
                    PastelCommon.logWarning("[SANITY: Advancement_Count Criteria] Advancement '" + String.valueOf(advancementHolder.id()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
                }
            }
        }
        for (AdvancementHolder advancementHolder : advancementLoader.getAllAdvancements()) {
            Object parentOfParentId;
            ResourceLocation advancementId = advancementHolder.id();
            String path = advancementId.getPath();
            Optional parentId = advancementHolder.value().parent();
            if (!advancementId.getNamespace().equals(modId) || path.startsWith("hidden") || path.startsWith("progression") || path.startsWith("milestones") || !parentId.isPresent()) continue;
            ResourceLocation gottenPreviousAdvancementIdentifier = null;
            for (List requirement : advancementHolder.value().requirements().requirements()) {
                if (requirement.isEmpty() || !((String)requirement.getFirst()).equals("gotten_previous")) continue;
                CriterionTriggerInstance conditions = ((Criterion)advancementHolder.value().criteria().get("gotten_previous")).triggerInstance();
                if (conditions instanceof HasAdvancementCriteria.HasAdvancementCriteriaInstance) {
                    HasAdvancementCriteria.HasAdvancementCriteriaInstance advancementConditions = (HasAdvancementCriteria.HasAdvancementCriteriaInstance)conditions;
                    gottenPreviousAdvancementIdentifier = advancementConditions.advancement();
                    break;
                }
                PastelCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' has a \"gotten_previous\" requirement, but its not of type revelationary:advancement_gotten");
            }
            if (ADVANCEMENT_GATING_WARNING_WHITELIST.contains(advancementId)) continue;
            if (gottenPreviousAdvancementIdentifier == null) {
                PastelCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' does not have its parent set as requirement");
                continue;
            }
            AdvancementHolder parentEntry = advancementLoader.get((ResourceLocation)parentId.get());
            if (parentEntry == null) {
                PastelCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' has its \"gotten_previous\" advancement set an advancement that does not exist.");
                continue;
            }
            if (parentEntry.id().equals(gottenPreviousAdvancementIdentifier) || ((Optional)(parentOfParentId = parentEntry.value().parent())).isPresent() && ((ResourceLocation)((Optional)parentOfParentId).get()).equals((Object)gottenPreviousAdvancementIdentifier)) continue;
            PastelCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' has its \"gotten_previous\" advancement set to something else than their parent. Intended?");
        }
        for (RecipeHolder recipeHolder : recipeManager.getAllRecipesFor(PastelRecipeTypes.PEDESTAL)) {
            PedestalRecipe recipe2 = (PedestalRecipe)recipeHolder.value();
            ResourceLocation id2 = recipeHolder.id();
            if (id2.getPath().startsWith("mod_integration/") || id2.getPath().contains("/glass/") || id2.getPath().contains("/saplings/") || id2.getPath().contains("/detectors/") || id2.getPath().contains("/gemstone_lights/") || id2.getPath().contains("/pylons/") || id2.getPath().contains("/runes/") || id2.getPath().contains("/pastel_network/") || id2.getPath().contains("/gemstone_chimes/") || id2.getPath().contains("/semi_permeable_glass/") || id2.getPath().contains("/colored_lamps/") || id2.getPath().contains("/colored_spore_blossoms/") || id2.getPath().contains("/glowblocks/")) continue;
            if (recipe2.getTier() == PedestalTier.BASIC && !id2.getPath().contains("/tier1/")) {
                PastelCommon.logWarning("[SANITY: Pedestal Recipes] BASIC recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
                continue;
            }
            if (recipe2.getTier() == PedestalTier.SIMPLE && !id2.getPath().contains("/tier2/")) {
                PastelCommon.logWarning("[SANITY: Pedestal Recipes] SIMPLE recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
                continue;
            }
            if (recipe2.getTier() == PedestalTier.ADVANCED && !id2.getPath().contains("/tier3/")) {
                PastelCommon.logWarning("[SANITY: Pedestal Recipes] ADVANCED recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
                continue;
            }
            if (recipe2.getTier() != PedestalTier.COMPLEX || id2.getPath().contains("/tier4/")) continue;
            PastelCommon.logWarning("[SANITY: Pedestal Recipes] COMPLEX recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
        }
        for (RecipeHolder recipeHolder : recipeManager.getAllRecipesFor(PastelRecipeTypes.ANVIL_CRUSHING)) {
            AnvilCrushingRecipe recipe3 = (AnvilCrushingRecipe)recipeHolder.value();
            SoundEvent soundEvent = recipe3.getSoundEvent();
            if (soundEvent != null) continue;
            PastelCommon.logWarning("[SANITY: Item Crushing] Recipe '" + String.valueOf(recipeHolder.id()) + "' has a nonexistent sound set");
        }
        HashMap<Holder, InkColor> craftingColors = new HashMap<Holder, InkColor>();
        HashMap<Holder, InkColor> hashMap = new HashMap<Holder, InkColor>();
        for (RecipeHolder recipeEntry : recipeManager.getAllRecipesFor(PastelRecipeTypes.ENCHANTER)) {
            recipe = (EnchanterCraftingRecipe)recipeEntry.value();
            output = ((EnchanterCraftingRecipe)recipe).getResultItem((HolderLookup.Provider)source.registryAccess());
            if (output.getItem() != Items.ENCHANTED_BOOK || (enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)output)).isEmpty()) continue;
            for (Ingredient ingredient : ((EnchanterCraftingRecipe)recipe).getIngredients()) {
                for (ItemStack matchingStack : ingredient.getItems()) {
                    Item item = matchingStack.getItem();
                    if (!(item instanceof PigmentItem)) continue;
                    PigmentItem pigmentItem = (PigmentItem)item;
                    craftingColors.put((Holder)enchantments.keySet().stream().toList().getFirst(), pigmentItem.getInkColor());
                }
            }
        }
        for (RecipeHolder recipeEntry : recipeManager.getAllRecipesFor(PastelRecipeTypes.ENCHANTMENT_UPGRADE)) {
            Item item;
            recipe = (EnchantmentUpgradeRecipe)recipeEntry.value();
            output = ((EnchantmentUpgradeRecipe)recipe).getResultItem((HolderLookup.Provider)source.registryAccess());
            if (output.getItem() != Items.ENCHANTED_BOOK || (enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)output)).isEmpty() || !((item = ((EnchantmentUpgradeRecipe)recipe).getBulkItem()) instanceof PigmentItem)) continue;
            PigmentItem pigmentItem = (PigmentItem)item;
            hashMap.put((Holder)enchantments.keySet().stream().toList().getFirst(), pigmentItem.getInkColor());
        }
        for (Enchantment enchantment : registryManager.registryOrThrow(Registries.ENCHANTMENT)) {
            entry = registryManager.registryOrThrow(Registries.ENCHANTMENT).wrapAsHolder((Object)enchantment);
            if (!craftingColors.containsKey(entry)) {
                PastelCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + entry.getRegisteredName() + "' does not have a crafting recipe");
            }
            if (!hashMap.containsKey(entry) && enchantment.getMaxLevel() > 1) {
                PastelCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + entry.getRegisteredName() + "' does not have a upgrading recipe");
            }
            if (!craftingColors.containsKey(entry) || !hashMap.containsKey(entry) || craftingColors.get(entry) == hashMap.get(entry)) continue;
            PastelCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment recipes for '" + entry.getRegisteredName() + "' use different pigments");
        }
        for (Enchantment enchantment : registryManager.registryOrThrow(Registries.ENCHANTMENT)) {
            entry = registryManager.registryOrThrow(Registries.ENCHANTMENT).wrapAsHolder((Object)enchantment);
            id = ((ResourceKey)entry.unwrapKey().get()).location();
            if (!id.getNamespace().equals(modId) || entry.is(PastelEnchantmentTags.SPECTRUM_ENCHANTMENT)) continue;
            PastelCommon.logWarning("[SANITY: Enchantment Tags] Enchantment '" + String.valueOf(id) + "' is missing in the pastel:enchantments tag");
        }
        for (Map.Entry item : BuiltInRegistries.ITEM.entrySet()) {
            PastelTrinketItem trinketItem;
            ResourceLocation advancementIdentifier;
            AdvancementHolder advancementCriterionAdvancement;
            id = item.getValue();
            if (!(id instanceof PastelTrinketItem) || (advancementCriterionAdvancement = advancementLoader.get(advancementIdentifier = (trinketItem = (PastelTrinketItem)((Object)id)).getUnlockIdentifier())) != null) continue;
            PastelCommon.logWarning("[SANITY: Trinkets] Trinket '" + String.valueOf(((ResourceKey)item.getKey()).location()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
        }
        PastelCommon.logInfo("##### SANITY CHECK FINISHED ######");
        PastelCommon.logInfo("##### SANITY CHECK PEDESTAL RECIPE STATISTICS ######");
        for (PedestalTier pedestalRecipeTier : PedestalTier.values()) {
            Map entry6 = (Map)usedColorsForEachTier.get((Object)pedestalRecipeTier);
            PastelCommon.logInfo("[SANITY: Pedestal Recipe Gemstone Usages] Gemstone Powder for tier " + StringUtils.leftPad((String)pedestalRecipeTier.toString(), (int)8) + ": C:" + StringUtils.leftPad((String)((Integer)entry6.get(PastelGemstoneColor.CYAN)).toString(), (int)4) + " M:" + StringUtils.leftPad((String)((Integer)entry6.get(PastelGemstoneColor.MAGENTA)).toString(), (int)4) + " Y:" + StringUtils.leftPad((String)((Integer)entry6.get(PastelGemstoneColor.YELLOW)).toString(), (int)4) + " K:" + StringUtils.leftPad((String)((Integer)entry6.get(PastelGemstoneColor.BLACK)).toString(), (int)4) + " W:" + StringUtils.leftPad((String)((Integer)entry6.get(PastelGemstoneColor.WHITE)).toString(), (int)4));
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"commands.pastel.progression_sanity.success"), false);
        }
        return 0;
    }

    private static <R extends GatedRecipe<C>, C extends RecipeInput> void testRecipeUnlocks(RecipeType<R> recipeType, String name, RecipeManager recipeManager, ServerAdvancementManager advancementLoader) {
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(recipeType)) {
            Optional<ResourceLocation> advancementIdentifier = ((GatedRecipe)recipe.value()).advancementID();
            if (!advancementIdentifier.isPresent() || advancementLoader.get(advancementIdentifier.get()) != null) continue;
            PastelCommon.logWarning("[SANITY: " + name + " Recipe Unlocks] Advancement '" + String.valueOf(advancementIdentifier) + "' in recipe '" + String.valueOf(recipe.id()) + "' does not exist");
        }
    }

    private static <R extends GatedRecipe<C>, C extends RecipeInput> void testIngredientsAndOutputInColorRegistry(RecipeType<R> recipeType, String name, RecipeManager recipeManager, RegistryAccess registryManager) {
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(recipeType)) {
            for (Ingredient inputIngredient : ((GatedRecipe)recipe.value()).getIngredients()) {
                for (ItemStack matchingItemStack : inputIngredient.getItems()) {
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.getItem()).isEmpty()) continue;
                    PastelCommon.logWarning("[SANITY: " + name + " Recipe] Input '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)matchingItemStack.getItem())) + "' in recipe '" + String.valueOf(recipe.id()) + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            Item outputItem = ((GatedRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryManager).getItem();
            if (outputItem == null || outputItem == Items.AIR || !ColorRegistry.ITEM_COLORS.getMapping(outputItem).isEmpty()) continue;
            PastelCommon.logWarning("[SANITY: " + name + " Recipe] Output '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)outputItem)) + "' in recipe '" + String.valueOf(recipe.id()) + "', does not exist in the item color registry. Add it for nice effects!");
        }
    }
}

