/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.capabilities.item;

import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class StackHandlerView
extends FriendlyStackHandler {
    protected final FriendlyStackHandler delegator;
    private final Int2ObjectMap<Predicate<ItemStack>> filters = new Int2ObjectArrayMap();
    private final int offset;
    private final int size;
    private boolean supportsInsertion = true;
    private boolean supportsExtraction = true;

    public StackHandlerView(FriendlyStackHandler delegator, int offset, int size) {
        super(null);
        this.delegator = delegator;
        this.offset = offset;
        this.size = size;
    }

    public StackHandlerView(FriendlyStackHandler delegator, int offset) {
        this(delegator, offset, 1);
    }

    public StackHandlerView(FriendlyStackHandler delegator) {
        this(delegator, 0, delegator.getSlots());
    }

    public StackHandlerView disableExtraction() {
        this.supportsExtraction = false;
        return this;
    }

    public StackHandlerView disableInsertion() {
        this.supportsInsertion = false;
        return this;
    }

    public int getSlots() {
        return this.size;
    }

    public StackHandlerView addFilter(int slot, Predicate<ItemStack> filter) {
        this.filters.put(slot, filter);
        return this;
    }

    public StackHandlerView addFilter(int slot) {
        this.filters.put(slot, stack -> false);
        return this;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.delegator.setStackInSlot(slot + this.offset, stack);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.delegator.getStackInSlot(slot + this.offset);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.supportsInsertion) {
            return stack;
        }
        if (!((Predicate)this.filters.getOrDefault(slot, stck -> true)).test(stack)) {
            return stack;
        }
        return this.delegator.insertItem(slot + this.offset, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.supportsExtraction) {
            return ItemStack.EMPTY;
        }
        return this.delegator.extractItem(slot + this.offset, amount, simulate);
    }

    @Override
    public ItemStack removeStackInSlot(int slot) {
        return this.delegator.removeStackInSlot(slot + this.offset);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return super.isItemValid(slot, stack);
    }

    @Override
    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    @Override
    public void setInternalList(NonNullList<ItemStack> newStacks) {
        throw new UnsupportedOperationException("Attempted to change the internal list of a forwarded ItemStackHandler");
    }

    public void setSize(int size) {
        throw new UnsupportedOperationException("Attempted to change the size of a forwarded ItemStackHandler");
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider provider) {
    }

    @Override
    public void load(CompoundTag tag, HolderLookup.Provider provider) {
    }
}

