/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.structure.PlayerTrackerBlockEntity;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TreasureItemBowlBlock
extends Block
implements EntityBlock {
    public static final MapCodec<TreasureItemBowlBlock> CODEC = TreasureItemBowlBlock.simpleCodec(TreasureItemBowlBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public TreasureItemBowlBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends TreasureItemBowlBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof PlayerTrackerBlockEntity)) {
            return InteractionResult.PASS;
        }
        PlayerTrackerBlockEntity bowl = (PlayerTrackerBlockEntity)entity;
        if (bowl.hasTaken(player) || !TreasureItemBowlBlock.canInteract(player)) {
            return InteractionResult.FAIL;
        }
        world.playLocalSound(pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        player.getInventory().placeItemBackInInventory(((Item)PastelItems.AETHER_GRACED_NECTAR_GLOVES.get()).getDefaultInstance());
        bowl.markTaken(player);
        return InteractionResult.CONSUME;
    }

    public static boolean canInteract(Player player) {
        return player.hasEffect(PastelMobEffects.FATAL_SLUMBER);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PlayerTrackerBlockEntity(pos, state);
    }
}

