/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntity;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlock;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlockEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.inventories.GenericPastelContainerScreenHandler;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreasureChestBlockEntity
extends PastelChestBlockEntity {
    private final List<UUID> playersThatOpenedAlready = new ArrayList<UUID>();
    private ResourceLocation requiredAdvancementIdentifierToOpen;
    private Vec3i controllerOffset;

    public TreasureChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.PRESERVATION_CHEST.get(), pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        if (this.requiredAdvancementIdentifierToOpen != null) {
            tag.putString("RequiredAdvancement", this.requiredAdvancementIdentifierToOpen.toString());
        }
        if (this.controllerOffset != null) {
            tag.putInt("ControllerOffsetX", this.controllerOffset.getX());
            tag.putInt("ControllerOffsetY", this.controllerOffset.getY());
            tag.putInt("ControllerOffsetZ", this.controllerOffset.getZ());
        }
        if (!this.playersThatOpenedAlready.isEmpty()) {
            ListTag uuidList = new ListTag();
            for (UUID uuid : this.playersThatOpenedAlready) {
                CompoundTag nbtCompound = new CompoundTag();
                nbtCompound.putUUID("UUID", uuid);
                uuidList.add((Object)nbtCompound);
            }
            tag.put("OpenedPlayers", (Tag)uuidList);
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.pastel.preservation_chest");
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return GenericPastelContainerScreenHandler.createGeneric9x3(syncId, playerInventory, (Container)this, ScreenBackgroundVariant.LATEGAME);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        if (tag.contains("RequiredAdvancement", 8)) {
            this.requiredAdvancementIdentifierToOpen = ResourceLocation.tryParse((String)tag.getString("RequiredAdvancement"));
        }
        if (tag.contains("ControllerOffsetX")) {
            this.controllerOffset = new Vec3i(tag.getInt("ControllerOffsetX"), tag.getInt("ControllerOffsetY"), tag.getInt("ControllerOffsetZ"));
        }
        this.playersThatOpenedAlready.clear();
        if (tag.contains("OpenedPlayers", 9)) {
            ListTag list = tag.getList("OpenedPlayers", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.getCompound(i);
                UUID uuid = compound.getUUID("UUID");
                this.playersThatOpenedAlready.add(uuid);
            }
        }
    }

    @Override
    public void onCloseSpectrum() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.controllerOffset != null && (blockEntity = serverWorld.getBlockEntity(Support.directionalOffset(this.worldPosition, this.controllerOffset, (Direction)serverWorld.getBlockState(this.worldPosition).getValue((Property)PreservationControllerBlock.FACING)))) instanceof PreservationControllerBlockEntity) {
                PreservationControllerBlockEntity controller = (PreservationControllerBlockEntity)blockEntity;
                controller.openExit();
            }
        }
    }

    public void unpackLootTable(@Nullable Player player) {
        if (player != null && this.lootTable != null && this.getLevel() != null && !this.hasOpenedThisChestBefore(player)) {
            this.supplyInventory(player);
            this.rememberPlayer(player);
        }
    }

    public boolean hasOpenedThisChestBefore(@NotNull Player player) {
        return this.playersThatOpenedAlready.contains(player.getUUID());
    }

    public void rememberPlayer(@NotNull Player player) {
        this.playersThatOpenedAlready.add(player.getUUID());
        this.setChanged();
    }

    public void supplyInventory(@NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LootTable lootTable = serverPlayer.serverLevel().getServer().reloadableRegistries().getLootTable(this.lootTable);
            LootParams.Builder builder = new LootParams.Builder(serverPlayer.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition));
            builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            lootTable.fill((Container)this, builder.create(LootContextParamSets.CHEST), this.lootTableSeed);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.GENERATE_LOOT.trigger(serverPlayer, this.lootTable);
            }
        }
    }

    public boolean canOpen(Player player) {
        if (this.requiredAdvancementIdentifierToOpen == null) {
            return true;
        }
        return DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)this.requiredAdvancementIdentifierToOpen);
    }

    public int getContainerSize() {
        return 27;
    }
}

