/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PreservationBlockDetectorBlockEntity
extends BlockEntity
implements CommandSource {
    @Nullable
    protected BlockState detectedState;
    @Nullable
    protected BlockState changeIntoState;
    protected List<String> commands = List.of();

    public PreservationBlockDetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.PRESERVATION_BLOCK_DETECTOR.get(), pos, state);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (this.changeIntoState != null) {
            nbt.putString("change_into_state", BlockStateParser.serialize((BlockState)this.changeIntoState));
        }
        if (this.detectedState != null) {
            nbt.putString("detected_state", BlockStateParser.serialize((BlockState)this.detectedState));
        }
        if (!this.commands.isEmpty()) {
            ListTag commandList = new ListTag();
            for (String s : this.commands) {
                commandList.add((Object)StringTag.valueOf((String)s));
            }
            nbt.put("commands", (Tag)commandList);
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.commands = new ArrayList<String>();
        this.changeIntoState = null;
        this.detectedState = null;
        if (nbt.contains("commands", 9)) {
            for (Tag e : nbt.getList("commands", 8)) {
                this.commands.add(e.getAsString());
            }
        }
        if (nbt.contains("change_into_state", 8)) {
            try {
                this.changeIntoState = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)nbt.getString("change_into_state"), (boolean)false).blockState();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (nbt.contains("detected_state", 8)) {
            try {
                this.detectedState = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)nbt.getString("detected_state"), (boolean)false).blockState();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public void triggerForNeighbor(BlockState state) {
        Level level;
        if ((this.detectedState == null || state.equals(this.detectedState)) && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.execute(serverWorld);
        }
    }

    public void execute(ServerLevel serverWorld) {
        MinecraftServer minecraftServer = serverWorld.getServer();
        AtomicBoolean failed = new AtomicBoolean(false);
        if (!this.commands.isEmpty()) {
            CommandSourceStack serverCommandSource = new CommandSourceStack((CommandSource)this, Vec3.atCenterOf((Vec3i)this.worldPosition), Vec2.ZERO, serverWorld, 2, "PreservationBlockDetector", (Component)this.getLevel().getBlockState(this.worldPosition).getBlock().getName(), minecraftServer, null).withCallback((success, returnValue) -> {
                if (returnValue < 1) {
                    failed.set(true);
                }
            });
            for (String command : this.commands) {
                minecraftServer.getCommands().performPrefixedCommand(serverCommandSource, command);
                if (!failed.get()) continue;
                break;
            }
            if (this.changeIntoState != null) {
                serverWorld.setBlockAndUpdate(this.worldPosition, this.changeIntoState);
            }
        }
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void sendSystemMessage(Component message) {
    }

    public boolean acceptsSuccess() {
        return false;
    }

    public boolean acceptsFailure() {
        return false;
    }

    public boolean shouldInformAdmins() {
        return false;
    }
}

