/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import earth.terrarium.pastel.blocks.redstone.RedstoneTransceiverBlock;
import earth.terrarium.pastel.events.game.PastelGameEvents;
import earth.terrarium.pastel.events.listeners.EventQueue;
import earth.terrarium.pastel.events.listeners.WirelessRedstoneSignalEventQueue;
import earth.terrarium.pastel.helpers.data.EventHelper;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneTransceiverBlockEntity
extends BlockEntity
implements EventQueue.Callback<WirelessRedstoneSignalEventQueue.EventEntry> {
    private static final int RANGE = 16;
    private final WirelessRedstoneSignalEventQueue listener;
    private int cachedSignal;
    private int currentSignal;

    public RedstoneTransceiverBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.REDSTONE_TRANSCEIVER.get(), blockPos, blockState);
        this.listener = new WirelessRedstoneSignalEventQueue((PositionSource)new BlockPositionSource(this.worldPosition), 16, this);
    }

    private static boolean isSender(Level world, BlockPos blockPos) {
        if (world == null) {
            return false;
        }
        return (Boolean)world.getBlockState(blockPos).getValue((Property)RedstoneTransceiverBlock.SENDER);
    }

    public static void serverTick(@NotNull Level world, BlockPos pos, BlockState state, @NotNull RedstoneTransceiverBlockEntity blockEntity) {
        if (RedstoneTransceiverBlockEntity.isSender(world, pos)) {
            if (blockEntity.currentSignal != blockEntity.cachedSignal) {
                blockEntity.currentSignal = blockEntity.cachedSignal;
                blockEntity.getLevel().gameEvent(PastelGameEvents.WIRELESS_REDSTONE_SIGNAL, blockEntity.getBlockPos(), new GameEvent.Context(null, state));
            }
        } else {
            blockEntity.listener.tick(world);
        }
    }

    public static DyeColor getChannel(Level world, BlockPos pos) {
        if (world == null) {
            return DyeColor.RED;
        }
        return (DyeColor)world.getBlockState(pos).getValue(RedstoneTransceiverBlock.CHANNEL);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        tag.putInt("signal", this.currentSignal);
        tag.putInt("cached_signal", this.cachedSignal);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        this.currentSignal = tag.getInt("output_signal");
        this.cachedSignal = tag.getInt("cached_signal");
    }

    @Nullable
    public WirelessRedstoneSignalEventQueue getEventListener() {
        return this.listener;
    }

    public int getRange() {
        return 16;
    }

    @Override
    public boolean canAcceptEvent(Level world, GameEventListener listener, GameEvent.ListenerInfo message, Vec3 sourcePos) {
        return !this.isRemoved() && message.gameEvent() == PastelGameEvents.WIRELESS_REDSTONE_SIGNAL && !RedstoneTransceiverBlockEntity.isSender(this.getLevel(), this.worldPosition) && EventHelper.getRedstoneEventDyeColor(message) == RedstoneTransceiverBlockEntity.getChannel(this.getLevel(), this.worldPosition);
    }

    @Override
    public void triggerEvent(Level world, GameEventListener listener, WirelessRedstoneSignalEventQueue.EventEntry redstoneEvent) {
        if (!RedstoneTransceiverBlockEntity.isSender(this.getLevel(), this.worldPosition) && EventHelper.getRedstoneEventDyeColor(redstoneEvent.gameEvent()) == RedstoneTransceiverBlockEntity.getChannel(this.getLevel(), this.worldPosition)) {
            int receivedSignal;
            this.currentSignal = receivedSignal = EventHelper.getRedstoneEventPower(world, redstoneEvent.gameEvent());
            if (receivedSignal == 0) {
                world.setBlock(this.worldPosition, (BlockState)world.getBlockState(this.worldPosition).setValue((Property)RedstoneTransceiverBlock.POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else {
                world.setBlock(this.worldPosition, (BlockState)world.getBlockState(this.worldPosition).setValue((Property)RedstoneTransceiverBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
            world.blockUpdated(this.worldPosition, (Block)PastelBlocks.REDSTONE_TRANSCEIVER.get());
        }
    }

    public void setSignalStrength(int newSignal) {
        if (RedstoneTransceiverBlockEntity.isSender(this.getLevel(), this.worldPosition)) {
            this.cachedSignal = newSignal;
        } else {
            this.currentSignal = newSignal;
        }
    }

    public int getCurrentSignal() {
        if (RedstoneTransceiverBlockEntity.isSender(this.getLevel(), this.worldPosition)) {
            return 0;
        }
        return this.currentSignal;
    }

    public int getCurrentSignalStrength() {
        return this.currentSignal;
    }
}

