/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.redstone.BlockPlacerBlockEntity;
import earth.terrarium.pastel.blocks.redstone.RedstoneInteractionBlock;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockPlacerBlock
extends RedstoneInteractionBlock
implements EntityBlock {
    public static final MapCodec<BlockPlacerBlock> CODEC = BlockPlacerBlock.simpleCodec(BlockPlacerBlock::new);

    public BlockPlacerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends BlockPlacerBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockPlacerBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlockPlacerBlockEntity) {
            BlockPlacerBlockEntity blockPlacerBlockEntity = (BlockPlacerBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockPlacerBlockEntity);
        }
        return InteractionResult.CONSUME;
    }

    protected void dispense(ServerLevel world, BlockState state, BlockPos pos) {
        BlockPlacerBlockEntity blockEntity = world.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.BLOCK_PLACER.get()).orElse(null);
        if (blockEntity == null) {
            PastelCommon.LOGGER.warn("Ignoring block place attempt for Block Player without matching block entity at {}", (Object)pos);
        } else {
            BlockSource pointer = new BlockSource(world, pos, state, (DispenserBlockEntity)blockEntity);
            int slot = blockEntity.getRandomSlot(world.random);
            if (slot < 0) {
                world.levelEvent(1001, pos, 0);
                world.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of((BlockState)blockEntity.getBlockState()));
            } else {
                ItemStack stack = blockEntity.getItem(slot);
                this.tryPlace(stack, pointer);
            }
        }
    }

    protected void tryPlace(@NotNull ItemStack stack, BlockSource pointer) {
        ServerLevel world = pointer.level();
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            Direction placementDirection;
            BlockItem blockItem = (BlockItem)item;
            Direction facing = ((FrontAndTop)pointer.state().getValue((Property)ORIENTATION)).front();
            BlockPos placementPos = pointer.pos().relative(facing);
            Direction direction = placementDirection = world.isEmptyBlock(placementPos.below()) ? facing : Direction.UP;
            if (!GenericClaimModsCompat.canPlaceBlock((Level)world, placementPos, null)) {
                return;
            }
            try {
                blockItem.place((BlockPlaceContext)new BlockPlacerPlacementContext((Level)world, placementPos, facing, stack, placementDirection));
                world.levelEvent(1000, pointer.pos(), 0);
                world.levelEvent(2000, pointer.pos(), ((FrontAndTop)pointer.state().getValue((Property)ORIENTATION)).front().get3DDataValue());
                world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, placementPos);
            }
            catch (Exception e) {
                PastelCommon.logError("Block Placer encountered an error placing a block at " + String.valueOf(placementPos) + " when placing " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)blockItem)));
                e.printStackTrace();
            }
        } else {
            world.levelEvent(1001, pointer.pos(), 0);
            world.gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, pointer.pos());
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean bl = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        boolean bl2 = (Boolean)state.getValue((Property)TRIGGERED);
        if (bl && !bl2) {
            world.scheduleTick(pos, (Block)this, 4);
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!bl && bl2) {
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.dispense(world, state, pos);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public static final class BlockPlacerPlacementContext
    extends DirectionalPlaceContext {
        public BlockPlacerPlacementContext(Level world, BlockPos pos, Direction facing, ItemStack stack, Direction side) {
            super(world, pos, facing, stack, side);
        }

        public boolean replacingClickedOnBlock() {
            return false;
        }
    }
}

