/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pedestal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.registries.client.PastelRenderLayers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PedestalBlockEntityRenderer<C extends PedestalBlockEntity>
implements BlockEntityRenderer<C> {
    private final ResourceLocation GROUND_MARK = PastelCommon.locate("textures/misc/circle.png");
    private final ModelPart circle = PedestalBlockEntityRenderer.getTexturedModelData().bakeRoot().getChild("circle");

    public PedestalBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("circle", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)0.1f, (float)8.0f));
        modelPartData.getChild("circle").addOrReplaceChild("circle2", CubeListBuilder.create().texOffs(0, 0).addBox(-32.0f, 0.0f, -29.0f, 64.0f, 0.0f, 64.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)256, (int)256);
    }

    public void render(PedestalBlockEntity pedestal, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        if (pedestal.getLevel() == null) {
            return;
        }
        if (pedestal.recipe.isEmpty()) {
            return;
        }
        Recipe recipe = pedestal.recipe.get().value();
        if (recipe instanceof PedestalRecipe) {
            PedestalRecipe pr = (PedestalRecipe)recipe;
            float time = (float)(pedestal.getLevel().getGameTime() % 50000L) + tickDelta;
            this.circle.yRot = time / 25.0f;
            this.circle.render(poseStack, vertexConsumerProvider.getBuffer(PastelRenderLayers.GlowInTheDarkRenderLayer.get(this.GROUND_MARK)), light, overlay);
            poseStack.pushPose();
            double height = Math.sin((double)time / 8.0) / 6.0;
            poseStack.translate(0.5, 1.3 + height, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(time * 2.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(pr.getResultItem((HolderLookup.Provider)pedestal.getLevel().registryAccess()), ItemDisplayContext.GROUND, 0xF000F0, overlay, poseStack, vertexConsumerProvider, pedestal.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

