/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.nodes;

import com.google.common.base.Predicates;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.FilterConfigurable;
import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.api.item.StampDataCategory;
import earth.terrarium.pastel.api.item.Stampable;
import earth.terrarium.pastel.api.pastel.PastelUpgradeSignature;
import earth.terrarium.pastel.api.pastel.PastelUpgradeable;
import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.blocks.pastel_network.network.NodeRemovalReason;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetworkManager;
import earth.terrarium.pastel.blocks.pastel_network.network.ServerPastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.ServerPastelNetworkManager;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlock;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeType;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.helpers.level.BlockReference;
import earth.terrarium.pastel.inventories.FilteringScreenHandler;
import earth.terrarium.pastel.networking.s2c_payloads.PastelNetworkEdgeSyncPayload;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelPastelUpgrades;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.registries.PastelStampDataCategories;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelNodeBlockEntity
extends BlockEntity
implements FilterConfigurable,
MenuProvider,
PastelUpgradeable,
Stampable {
    public static final int MAX_FILTER_SLOTS = 25;
    public static final int SLOTS_PER_ROW = 5;
    public static final int DEFAULT_FILTER_SLOT_ROWS = 1;
    public static final int RANGE = 12;
    @NotNull
    protected UUID nodeId = UUID.randomUUID();
    protected Optional<UUID> networkUUID = Optional.empty();
    protected Optional<PastelUpgradeSignature> outerRing;
    protected Optional<PastelUpgradeSignature> innerRing;
    protected Optional<PastelUpgradeSignature> redstoneRing;
    protected Optional<DyeColor> color = Optional.empty();
    protected long lastTransferTick = 0L;
    protected final long cachedRedstonePowerTick = 0L;
    protected boolean cachedUnpowered = true;
    protected PastelNetwork.NodePriority priority = PastelNetwork.NodePriority.GENERIC;
    protected long itemCountUnderway = 0L;
    protected boolean lit;
    protected boolean triggerTransfer;
    protected boolean triggered;
    protected boolean waiting;
    protected boolean lamp;
    protected boolean sensor;
    protected boolean updated;
    protected int transferCount = 1;
    protected int transferTime = 30;
    protected int filterSlotRows = 1;
    protected Optional<BlockCapabilityCache<IItemHandler, Direction>> cache = Optional.empty();
    protected Direction cacheDirection = null;
    private final NonNullList<ItemReference> filterItems = NonNullList.withSize((int)25, (Object)ItemReference.empty());
    float rotationTarget;
    float crystalRotation;
    float lastRotationTarget;
    float heightTarget;
    float crystalHeight;
    float lastHeightTarget;
    float alphaTarget;
    float ringAlpha;
    float lastAlphaTarget;
    long creationStamp = -1L;
    long interpTicks;
    long interpLength = -1L;
    long spinTicks;
    private ConnectionState connectionState;

    public PastelNodeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.PASTEL_NODE.get(), blockPos, blockState);
        this.outerRing = Optional.empty();
        this.innerRing = Optional.empty();
        this.redstoneRing = Optional.empty();
    }

    @Nullable
    public IItemHandler getConnectedHandler() {
        if (this.cache.isEmpty()) {
            this.cacheDirection = (Direction)this.getBlockState().getValue((Property)PastelNodeBlock.FACING);
            this.cache = Optional.of(BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().relative(this.cacheDirection.getOpposite()), (Object)this.cacheDirection, () -> !this.isRemoved(), () -> {
                this.cache = Optional.empty();
            }));
        }
        return (IItemHandler)this.cache.get().getCapability();
    }

    public static void tick(@NotNull Level world, BlockPos pos, BlockState state, PastelNodeBlockEntity node) {
        if (node.lamp && ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() != node.canTransfer()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(node.cachedUnpowered)));
        }
        if (node.triggerTransfer) {
            boolean powered = world.hasNeighborSignal(pos);
            if (node.waiting && !powered) {
                node.waiting = false;
            }
            if (!node.triggered && !node.waiting && powered) {
                node.triggered = true;
            }
        }
        if (world.isClientSide()) {
            if (node.networkUUID.isEmpty()) {
                node.changeConnectionState(ConnectionState.DISCONNECTED);
                node.interpLength = 17L;
            } else if (!node.canTransfer()) {
                node.changeConnectionState(ConnectionState.INACTIVE);
                node.interpLength = 21L;
            } else if (node.spinTicks > 0L) {
                node.changeConnectionState(ConnectionState.ACTIVE);
                node.interpLength = 17L;
            } else {
                node.changeConnectionState(ConnectionState.CONNECTED);
                node.interpLength = 13L;
            }
            if (node.interpTicks < node.interpLength) {
                ++node.interpTicks;
            }
            if (node.spinTicks > 0L) {
                --node.spinTicks;
            }
        } else if (!node.updated) {
            node.updateUpgrades();
            node.updated = true;
        }
    }

    public void changeConnectionState(ConnectionState connectionState) {
        if (this.connectionState != connectionState) {
            this.connectionState = connectionState;
            this.lastRotationTarget = this.crystalRotation;
            this.lastHeightTarget = this.crystalHeight;
            this.lastAlphaTarget = this.ringAlpha;
            this.interpTicks = 0L;
        }
    }

    public Optional<PastelUpgradeSignature> getInnerRing() {
        return this.innerRing;
    }

    public Optional<PastelUpgradeSignature> getOuterRing() {
        return this.outerRing;
    }

    public Optional<PastelUpgradeSignature> getRedstoneRing() {
        return this.redstoneRing;
    }

    public PastelNetwork.NodePriority getPriority() {
        return this.priority;
    }

    public boolean tryInteractRings(ItemStack item, PastelNodeType type) {
        PastelUpgradeSignature upgrade = PastelPastelUpgrades.of(item);
        if (upgrade.category.isRedstone()) {
            if (this.redstoneRing.isEmpty()) {
                this.redstoneRing = Optional.of(upgrade);
                return true;
            }
            return false;
        }
        if (this.outerRing.isEmpty() && type.hasOuterRing()) {
            this.outerRing = Optional.of(upgrade);
            return true;
        }
        if (this.innerRing.isEmpty()) {
            this.innerRing = Optional.of(upgrade);
            return true;
        }
        return false;
    }

    public ItemStack tryRemoveUpgrade() {
        ItemStack stack = ItemStack.EMPTY;
        if (this.redstoneRing.isPresent()) {
            stack = this.redstoneRing.get().upgradeItem.getDefaultInstance();
            this.redstoneRing = Optional.empty();
        } else if (this.innerRing.isPresent()) {
            stack = this.innerRing.get().upgradeItem.getDefaultInstance();
            this.innerRing = Optional.empty();
        } else if (this.outerRing.isPresent()) {
            stack = this.outerRing.get().upgradeItem.getDefaultInstance();
            this.outerRing = Optional.empty();
        }
        if (!stack.isEmpty()) {
            this.level.playLocalSound(this.worldPosition, PastelSounds.SHATTER_LIGHT, SoundSource.BLOCKS, 0.25f, 0.9f + this.level.getRandom().nextFloat() * 0.2f, true);
            this.setChanged();
        }
        return stack;
    }

    public void updateUpgrades() {
        this.transferCount = 1;
        this.transferTime = 30;
        int oldFilterSlotCount = this.filterSlotRows;
        this.filterSlotRows = 1;
        this.triggerTransfer = false;
        this.lit = false;
        this.lamp = false;
        this.sensor = false;
        PastelNetwork.NodePriority oldPriority = this.priority;
        this.priority = PastelNetwork.NodePriority.GENERIC;
        this.outerRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, Collections.emptyList()));
        this.innerRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, this.outerRing.map(List::of).orElse(Collections.emptyList())));
        this.redstoneRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, Collections.emptyList()));
        this.transferCount = Math.max(this.transferCount, 1);
        this.transferTime = Mth.clamp((int)this.transferTime, (int)2, (int)100);
        this.filterSlotRows = Mth.clamp((int)this.filterSlotRows, (int)1, (int)5);
        if (this.lit && this.lamp) {
            this.lit = false;
        }
        if (this.level != null) {
            this.networkUUID.ifPresent(uuid -> ServerPastelNetworkManager.get((ServerLevel)this.level).getNetwork((UUID)uuid).ifPresent(n -> n.updateNodePriority(this, oldPriority)));
            if ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.LIT) != this.lit) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.lit)));
            }
        }
        if (this.filterSlotRows < oldFilterSlotCount) {
            for (int i = this.getDrawnSlots(); i < this.filterItems.size(); ++i) {
                this.filterItems.set(i, (Object)ItemReference.empty());
            }
        }
    }

    @Override
    public void notifySensor() {
        if (this.level != null) {
            BlockState state = this.getBlockState();
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
            if (!this.level.getBlockTicks().hasScheduledTick(this.worldPosition, (Object)state.getBlock())) {
                this.level.scheduleTick(this.worldPosition, state.getBlock(), 2);
            }
        }
    }

    public long getMaxTransferredAmount() {
        return this.transferCount;
    }

    public int getTransferTime() {
        return this.transferTime;
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        if (!world.isClientSide()) {
            this.getServerNetwork().ifPresent(network -> network.initializeNode(this));
        }
    }

    public float getRedstoneAlphaMult() {
        return this.redstoneRing.isPresent() ? 0.5f : 0.25f;
    }

    public boolean canTransfer() {
        boolean canTransfer;
        InteractionResult result = this.redstoneRing.map(r -> r.preProcessor.apply(new PastelUpgradeSignature.RedstoneContext(this, this.level, this.worldPosition, this.cachedUnpowered))).orElse(InteractionResult.PASS);
        if (result == InteractionResult.SUCCESS) {
            return true;
        }
        if (result == InteractionResult.FAIL) {
            return false;
        }
        long time = this.getLevel().getGameTime();
        if (time > this.cachedRedstonePowerTick && !((Boolean)this.getBlockState().getValue((Property)PastelNodeBlock.REDSTONE_EMITTING)).booleanValue()) {
            this.cachedUnpowered = this.level.getBestNeighborSignal(this.worldPosition) == 0;
        }
        boolean notPowered = this.redstoneRing.map(r -> {
            InteractionResult post = r.postProcessor.apply(new PastelUpgradeSignature.RedstoneContext(this, this.level, this.worldPosition, this.cachedUnpowered));
            if (post == InteractionResult.SUCCESS) {
                return true;
            }
            if (post == InteractionResult.FAIL) {
                return false;
            }
            return this.cachedUnpowered;
        }).orElse(this.cachedUnpowered);
        boolean bl = canTransfer = this.getLevel().getGameTime() > this.lastTransferTick;
        if (this.triggerTransfer) {
            return this.triggered && canTransfer;
        }
        return canTransfer && notPowered;
    }

    public void markTransferred() {
        if (this.triggerTransfer) {
            this.markTriggered();
        }
        this.lastTransferTick = this.level.getGameTime();
        this.setChanged();
    }

    public Optional<UUID> getNetworkUUID() {
        return this.networkUUID;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.nodeId = nbt.contains("NodeID") ? nbt.getUUID("NodeID") : UUID.randomUUID();
        this.networkUUID = nbt.contains("NetworkUUID") ? Optional.of(nbt.getUUID("NetworkUUID")) : Optional.empty();
        this.triggered = nbt.contains("Triggered") && nbt.getBoolean("Triggered");
        this.waiting = nbt.contains("Waiting") && nbt.getBoolean("Waiting");
        this.creationStamp = nbt.contains("creationStamp") ? nbt.getLong("creationStamp") : 0L;
        this.lastTransferTick = nbt.contains("LastTransferTick", 4) ? nbt.getLong("LastTransferTick") : 0L;
        this.itemCountUnderway = nbt.contains("ItemCountUnderway", 4) ? nbt.getLong("ItemCountUnderway") : 0L;
        this.outerRing = nbt.contains("OuterRing") ? Optional.ofNullable((PastelUpgradeSignature)PastelRegistries.PASTEL_UPGRADE.get(ResourceLocation.tryParse((String)nbt.getString("OuterRing")))) : Optional.empty();
        this.innerRing = nbt.contains("InnerRing") ? Optional.ofNullable((PastelUpgradeSignature)PastelRegistries.PASTEL_UPGRADE.get(ResourceLocation.tryParse((String)nbt.getString("InnerRing")))) : Optional.empty();
        Optional<Object> optional = this.redstoneRing = nbt.contains("RedstoneRing") ? Optional.ofNullable((PastelUpgradeSignature)PastelRegistries.PASTEL_UPGRADE.get(ResourceLocation.tryParse((String)nbt.getString("RedstoneRing")))) : Optional.empty();
        if (this.getNodeType().usesFilters()) {
            FilterConfigurable.readFilterNbt(nbt, this.filterItems, registryLookup);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (this.creationStamp != -1L) {
            nbt.putLong("creationStamp", this.creationStamp);
        }
        if (this.networkUUID.isPresent()) {
            nbt.putUUID("NetworkUUID", this.networkUUID.get());
        }
        nbt.putUUID("NodeID", this.nodeId);
        nbt.putBoolean("Triggered", this.triggered);
        nbt.putBoolean("Waiting", this.waiting);
        nbt.putLong("LastTransferTick", this.lastTransferTick);
        nbt.putLong("ItemCountUnderway", this.itemCountUnderway);
        if (this.getNodeType().usesFilters()) {
            FilterConfigurable.writeFilterNbt(nbt, this.filterItems, registryLookup);
        }
        this.outerRing.ifPresent(r -> nbt.putString("OuterRing", PastelPastelUpgrades.toString(r)));
        this.innerRing.ifPresent(r -> nbt.putString("InnerRing", PastelPastelUpgrades.toString(r)));
        this.redstoneRing.ifPresent(r -> nbt.putString("RedstoneRing", PastelPastelUpgrades.toString(r)));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        Optional<ServerPastelNetwork> network = this.getServerNetwork();
        network.ifPresent(serverPastelNetwork -> PastelNetworkEdgeSyncPayload.send(serverPastelNetwork, this.worldPosition));
        CompoundTag nbtCompound = new CompoundTag();
        this.saveAdditional(nbtCompound, registryLookup);
        return nbtCompound;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide()) {
            Pastel.getServerInstance().removeNode(this, NodeRemovalReason.UNLOADED);
        }
    }

    @NotNull
    public UUID getNodeId() {
        return this.nodeId;
    }

    public void onBroken() {
        if (this.level != null && !this.level.isClientSide) {
            Pastel.getServerInstance().removeNode(this, NodeRemovalReason.BROKEN);
        }
    }

    public PastelNodeType getNodeType() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof PastelNodeBlock) {
            PastelNodeBlock pastelNodeBlock = (PastelNodeBlock)block;
            return pastelNodeBlock.pastelNodeType;
        }
        return PastelNodeType.CONNECTION;
    }

    public void setNetworkUUID(@Nullable UUID uuid) {
        this.networkUUID = Optional.ofNullable(uuid);
        if (this.getLevel() != null && !this.getLevel().isClientSide()) {
            this.setChanged();
            this.updateInClientWorld();
        }
    }

    public long getItemCountUnderway() {
        return this.itemCountUnderway;
    }

    public void addItemCountUnderway(long count) {
        this.itemCountUnderway += count;
        this.itemCountUnderway = Math.max(0L, this.itemCountUnderway);
        this.setChanged();
    }

    public void updateInClientWorld() {
        ((ServerLevel)this.level).getChunkSource().blockChanged(this.worldPosition);
    }

    @Override
    public NonNullList<ItemReference> getItemFilters() {
        return this.filterItems;
    }

    @Override
    public void setFilterItem(int slot, ItemStack item) {
        this.filterItems.set(slot, (Object)ItemReference.of(item));
    }

    public Predicate<ItemStack> getTransferFilterTo(PastelNodeBlockEntity other) {
        if (this.getNodeType().usesFilters() && !this.hasEmptyFilter()) {
            if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
                return Predicates.and(this::filter, other::filter);
            }
            return this::filter;
        }
        if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
            return other::filter;
        }
        return ItemStack2 -> true;
    }

    private boolean filter(ItemStack variant) {
        return this.filterItems.stream().anyMatch(filterItem -> {
            if (!filterItem.has(DataComponents.CUSTOM_NAME) || !filterItem.asStack().is(PastelItemTags.TAG_FILTERING_ITEMS)) {
                return filterItem.permits(variant);
            }
            String name = StringUtils.trim((String)filterItem.asStack().getHoverName().getString());
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{"*", "any", "all", "everything", "c:*", "c:any", "c:all", "c:everything"})) {
                return true;
            }
            ResourceLocation id = ResourceLocation.tryParse((String)StringUtils.remove((String)name, (char)'#'));
            if (id == null) {
                return false;
            }
            TagKey tag = PastelCommon.CACHED_ITEM_TAG_MAP.computeIfAbsent(id, tagId -> BuiltInRegistries.ITEM.getTagNames().filter((? super T t) -> t.location().equals(tagId)).findFirst().orElse(null));
            if (tag == null) {
                return false;
            }
            return variant.getItem().builtInRegistryHolder().is(tag);
        });
    }

    @Override
    public boolean handleImpression(Optional<UUID> stamper, Optional<Player> user, BlockReference reference, Level world) {
        PastelNodeBlockEntity sourceNode = (PastelNodeBlockEntity)reference.tryGetBlockEntity().orElseThrow(() -> new IllegalStateException("Attempted to connect a non-existent node - what did you do?!"));
        PastelNetworkManager<?, ?> manager = Pastel.getInstance(world.isClientSide());
        Optional<?> sourceNetwork = manager.getNetworkOrEmpty(sourceNode.networkUUID);
        Optional<?> thisNetwork = manager.getNetworkOrEmpty(this.networkUUID);
        if (!sourceNode.canConnect(this)) {
            return false;
        }
        if (sourceNetwork.isPresent() && sourceNetwork.equals(thisNetwork)) {
            if (((PastelNetwork)sourceNetwork.get()).removeEdge(this, sourceNode)) {
                return true;
            }
            return ((PastelNetwork)sourceNetwork.get()).addEdge(this, sourceNode);
        }
        if (!world.isClientSide()) {
            Pastel.getServerInstance().connectNodes(this, sourceNode);
        }
        thisNetwork.ifPresent(n -> user.filter((? super T u) -> u instanceof ServerPlayer).ifPresent(p -> PastelCriteria.PASTEL_NETWORK_CREATING.trigger((ServerPlayer)p, (ServerPastelNetwork)n)));
        return true;
    }

    @Override
    public Stampable.StampData recordStampData(Optional<Player> user, BlockReference reference, Level world) {
        return new Stampable.StampData(user.map(Entity::getUUID), reference, (Stampable)this);
    }

    @Override
    public StampDataCategory getStampCategory() {
        return PastelStampDataCategories.PASTEL;
    }

    @Override
    public boolean canUserStamp(Optional<Player> stamper) {
        return true;
    }

    @Override
    public void onImpressedOther(Stampable.StampData data, boolean success) {
    }

    public long getCreationStamp() {
        return this.creationStamp;
    }

    @Override
    public void clearImpression() {
        if (!this.level.isClientSide()) {
            Pastel.getServerInstance().removeNode(this, NodeRemovalReason.DISCONNECT);
        }
        this.networkUUID = Optional.empty();
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.pastel.pastel_node");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new FilteringScreenHandler(syncId, inv, new FilterConfigurable.ExtendedData(this));
    }

    @Override
    public int getFilterRows() {
        return this.filterSlotRows;
    }

    @Override
    public int getDrawnSlots() {
        return this.getFilterRows() * 5;
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        FilterConfigurable.ExtendedData.STREAM_CODEC.encode((Object)buffer, (Object)new FilterConfigurable.ExtendedData(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PastelNodeBlockEntity)) return false;
        PastelNodeBlockEntity blockEntity = (PastelNodeBlockEntity)obj;
        if (!this.worldPosition.equals((Object)blockEntity.worldPosition)) return false;
        return true;
    }

    public int hashCode() {
        return this.worldPosition.hashCode();
    }

    public ConnectionState getState() {
        return this.connectionState;
    }

    public Optional<DyeColor> getColor() {
        return this.color;
    }

    public boolean setColor(Optional<DyeColor> color, @Nullable Entity user) {
        if (this.color == color) {
            return false;
        }
        this.color = color;
        Optional network = this.networkUUID.flatMap(id -> Pastel.getInstance(this.level.isClientSide()).getNetwork((UUID)id));
        if (network.isPresent()) {
            ((PastelNetwork)network.get()).setColor(color);
        }
        return true;
    }

    public boolean canConnect(PastelNodeBlockEntity target) {
        return this != target && this.getBlockPos().closerThan((Vec3i)target.getBlockPos(), 12.0);
    }

    public Optional<ServerPastelNetwork> getServerNetwork() {
        if (this.networkUUID.isPresent()) {
            return Pastel.getServerInstance().getNetwork(this.networkUUID.get());
        }
        return Optional.empty();
    }

    public int getPastelNetworkColor() {
        Optional<DyeColor> color = this.getColor();
        return color.isPresent() ? color.get().getTextureDiffuseColor() : ColorHelper.getRandomColor(this.getNodeId().hashCode());
    }

    public void setSpinTicks(long spinTicks) {
        this.spinTicks = spinTicks;
    }

    @Override
    public void markLit() {
        this.lit = true;
    }

    @Override
    public void markLamp() {
        this.lamp = true;
    }

    @Override
    public void markTriggerTransfer() {
        this.triggerTransfer = true;
    }

    @Override
    public void markSensor() {
        this.sensor = true;
    }

    @Override
    public void markTriggered() {
        this.triggered = false;
        this.waiting = true;
    }

    @Override
    public boolean isTriggerTransfer() {
        return this.triggerTransfer;
    }

    @Override
    public boolean isSensor() {
        return this.sensor;
    }

    @Override
    public void applySlotUpgrade(PastelUpgradeSignature upgrade) {
        this.filterSlotRows += this.getNodeType().hasOuterRing() ? upgrade.slotRows : upgrade.slotRows * 2;
    }

    @Override
    public void applySimple(PastelUpgradeSignature upgrade) {
        this.transferCount += upgrade.stack;
        this.transferTime += upgrade.speed;
    }

    @Override
    public void applyCompounding(PastelUpgradeSignature upgrade) {
        this.transferCount = Math.round((float)this.transferCount * upgrade.stackMult);
        this.transferTime = Math.round((float)this.transferTime * upgrade.speedMult);
    }

    @Override
    public void upgradePriority() {
        this.priority = this.priority == PastelNetwork.NodePriority.GENERIC ? PastelNetwork.NodePriority.MODERATE : PastelNetwork.NodePriority.HIGH;
    }

    public String toString() {
        return this.getNodeType().toString() + "-" + this.getColor().toString() + "-" + this.getBlockPos().toString() + "-" + String.valueOf(this.getNodeId());
    }

    public static enum ConnectionState {
        DISCONNECTED,
        CONNECTED,
        ACTIVE,
        INACTIVE;

    }
}

