/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.network;

import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelTransmission;
import earth.terrarium.pastel.blocks.pastel_network.network.ServerPastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeType;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PastelNodeStatusUpdatePayload;
import earth.terrarium.pastel.networking.s2c_payloads.PastelTransmissionPayload;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultEdge;

public class PastelTransmissionLogic {
    public static final int DEFAULT_MAX_TRANSFER_AMOUNT = 1;
    public static final int DEFAULT_TRANSFER_TICKS_PER_NODE = 30;
    private final ServerPastelNetwork network;
    private DijkstraShortestPath<BlockPos, DefaultEdge> dijkstra;
    private Map<BlockPos, Map<BlockPos, GraphPath<BlockPos, DefaultEdge>>> pathCache = new HashMap<BlockPos, Map<BlockPos, GraphPath<BlockPos, DefaultEdge>>>();

    public PastelTransmissionLogic(ServerPastelNetwork network) {
        this.network = network;
    }

    public void invalidateCache() {
        this.dijkstra = null;
        this.pathCache = new HashMap<BlockPos, Map<BlockPos, GraphPath<BlockPos, DefaultEdge>>>();
    }

    @Nullable
    public GraphPath<BlockPos, DefaultEdge> getPath(Graph<BlockPos, DefaultEdge> graph, PastelNodeBlockEntity source, PastelNodeBlockEntity destination) {
        Map e;
        if (this.dijkstra == null) {
            this.dijkstra = new DijkstraShortestPath(graph);
        }
        if ((e = (Map)this.pathCache.getOrDefault(source.getBlockPos(), null)) != null && e.containsKey(destination.getBlockPos())) {
            return (GraphPath)e.get(destination.getBlockPos());
        }
        ShortestPathAlgorithm.SingleSourcePaths paths = this.dijkstra.getPaths((Object)source.getBlockPos());
        GraphPath path = paths.getPath((Object)destination.getBlockPos());
        if (this.pathCache.containsKey(source.getBlockPos())) {
            this.pathCache.get(source.getBlockPos()).put(destination.getBlockPos(), (GraphPath<BlockPos, DefaultEdge>)path);
        } else {
            HashMap<BlockPos, GraphPath> newMap = new HashMap<BlockPos, GraphPath>();
            newMap.put(destination.getBlockPos(), path);
            this.pathCache.put(source.getBlockPos(), newMap);
        }
        return path;
    }

    public void tick(PastelNetwork.NodePriority priority) {
        this.transferBetween(PastelNodeType.BUFFER, PastelNodeType.GATHER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.GATHER, TransferMode.PUSH_PULL, priority);
        this.transferBetween(PastelNodeType.PROVIDER, PastelNodeType.GATHER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.STORAGE, PastelNodeType.GATHER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.BUFFER, TransferMode.PUSH_PULL, priority);
        this.transferBetween(PastelNodeType.PROVIDER, PastelNodeType.BUFFER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.STORAGE, PastelNodeType.BUFFER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.STORAGE, TransferMode.PUSH, priority);
    }

    private void transferBetween(PastelNodeType sourceType, PastelNodeType destinationType, TransferMode transferMode, PastelNetwork.NodePriority priority) {
        for (PastelNodeBlockEntity sourceNode : this.network.getLoadedNodes(sourceType, priority)) {
            IItemHandler sourceHandler;
            if (!sourceNode.canTransfer() || (sourceHandler = sourceNode.getConnectedHandler()) == null) continue;
            this.tryTransferToType(sourceNode, sourceHandler, destinationType, transferMode);
        }
    }

    private void tryTransferToType(PastelNodeBlockEntity sourceNode, IItemHandler sourceHandler, PastelNodeType type, TransferMode transferMode) {
        for (PastelNodeBlockEntity targetNode : this.network.getLoadedNodes(type, PastelNetwork.NodePriority.GENERIC)) {
            boolean success;
            IItemHandler targetHandler;
            if (!targetNode.canTransfer() || (targetHandler = targetNode.getConnectedHandler()) == null || !(success = this.transferBetween(sourceNode, sourceHandler, targetNode, targetHandler, transferMode)) || transferMode == TransferMode.PULL) continue;
            return;
        }
    }

    private boolean transferBetween(PastelNodeBlockEntity sourceNode, IItemHandler sourceStorage, PastelNodeBlockEntity destinationNode, IItemHandler destinationStorage, TransferMode transferMode) {
        long totalAvailableStorage = -destinationNode.getItemCountUnderway();
        for (int d = 0; d < destinationStorage.getSlots(); ++d) {
            ItemStack stack = destinationStorage.getStackInSlot(d);
            if (stack.isEmpty()) {
                totalAvailableStorage += (long)destinationStorage.getSlotLimit(d);
                continue;
            }
            totalAvailableStorage += (long)(Math.min(destinationStorage.getSlotLimit(d), stack.getMaxStackSize()) - stack.getCount());
        }
        if (totalAvailableStorage <= 0L) {
            return false;
        }
        Predicate<ItemStack> filter = sourceNode.getTransferFilterTo(destinationNode);
        HashMap<ItemEntry, Long> proposals = new HashMap<ItemEntry, Long>();
        for (int s = 0; s < sourceStorage.getSlots(); ++s) {
            ItemStack stack = sourceStorage.extractItem(s, 1, true);
            if (stack.isEmpty() || !filter.test(stack)) continue;
            ItemEntry entry = new ItemEntry(stack);
            proposals.put(entry, proposals.getOrDefault(entry, 0L) + (long)entry.stack.getCount());
        }
        for (ItemEntry proposal : proposals.keySet()) {
            Optional<PastelTransmission> trans;
            long proposedAmount = Math.min(Math.min((Long)proposals.get(proposal), sourceNode.getMaxTransferredAmount()), totalAvailableStorage);
            if (proposedAmount == 0L) continue;
            ItemStack proposedStack = proposal.stack.copyWithCount((int)proposedAmount);
            long simulatedAmount = proposedAmount - (long)ItemHandlerHelper.insertItemStacked((IItemHandler)destinationStorage, (ItemStack)proposedStack, (boolean)true).getCount();
            if ((simulatedAmount = Math.min(simulatedAmount, (long)InventoryHelper.getStackCountInInventory(sourceStorage, proposedStack))) == 0L || !(trans = this.createTransmissionOnValidPath(sourceNode, destinationNode, proposedStack, simulatedAmount, sourceNode.getTransferTime())).isPresent()) continue;
            InventoryHelper.extractFromInventory(sourceStorage, ItemReference.of(proposedStack), (int)simulatedAmount);
            this.network.addTransmission(trans.get(), trans.get().getTransmissionDuration());
            PastelTransmissionPayload.sendPastelTransmissionParticle(this.network, trans.get().getTransmissionDuration(), trans.get());
            if (transferMode == TransferMode.PULL) {
                destinationNode.markTransferred();
            } else if (transferMode == TransferMode.PUSH) {
                sourceNode.markTransferred();
            } else {
                destinationNode.markTransferred();
                sourceNode.markTransferred();
            }
            destinationNode.addItemCountUnderway(simulatedAmount);
            return true;
        }
        return false;
    }

    public Optional<PastelTransmission> createTransmissionOnValidPath(PastelNodeBlockEntity source, PastelNodeBlockEntity destination, ItemStack variant, long amount, int vertexTime) {
        GraphPath<BlockPos, DefaultEdge> graphPath = this.getPath(this.network.getGraph(), source, destination);
        if (graphPath != null) {
            PastelNodeStatusUpdatePayload.sendPastelNodeStatusUpdate(List.of(source), true);
            return Optional.of(new PastelTransmission(graphPath.getVertexList(), variant, amount, vertexTime));
        }
        return Optional.empty();
    }

    private static enum TransferMode {
        PUSH,
        PULL,
        PUSH_PULL;

    }

    private record ItemEntry(ItemStack stack) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            ItemStack entry;
            if (!(obj instanceof ItemEntry)) return false;
            ItemEntry itemEntry = (ItemEntry)obj;
            try {
                ItemStack itemStack;
                entry = itemStack = itemEntry.stack();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)entry);
        }

        @Override
        public int hashCode() {
            return ItemStack.hashItemAndComponents((ItemStack)this.stack);
        }
    }
}

