/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import earth.terrarium.pastel.blocks.decoration.PastelFacingBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JadeiteLotusFlowerBlock
extends PastelFacingBlock {
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public JadeiteLotusFlowerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState(this.defaultBlockState());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
        }
        return SHAPE_WEST;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos root = pos.relative(facing.getOpposite());
        BlockState supportBlock = world.getBlockState(root);
        return facing.getAxis().isVertical() && supportBlock.is((Block)PastelBlocks.JADEITE_LOTUS_STEM.get()) || supportBlock.isFaceSturdy((BlockGetter)world, root, facing, SupportType.CENTER);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int amount = random.nextInt(18) + 9;
        for (int i = 0; i < amount; ++i) {
            float xOffset = Mth.clamp((float)Mth.normal((RandomSource)random, (float)0.5f, (float)5.85f), (float)-9.0f, (float)9.0f) + 0.5f;
            float yOffset = Mth.clamp((float)Mth.normal((RandomSource)random, (float)0.5f, (float)5.85f), (float)-9.0f, (float)9.0f) + 0.5f;
            float zOffset = Mth.clamp((float)Mth.normal((RandomSource)random, (float)0.5f, (float)5.85f), (float)-9.0f, (float)9.0f) + 0.5f;
            world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.END_ROD, (double)((float)pos.getX() + xOffset), (double)((float)pos.getY() + yOffset), (double)((float)pos.getZ() + zOffset), (double)random.nextFloat() * 0.05 - 0.025, (double)random.nextFloat() * 0.05 - 0.025, (double)random.nextFloat() * 0.05 - 0.025);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }
}

