/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.effect.ColoredFallingSporeBlossomParticleEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public interface JadeVine {
    public static final BooleanProperty DEAD = BooleanProperty.create((String)"dead");
    public static final VoxelShape BULB_SHAPE = Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape TIP_SHAPE = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public static void spawnBloomParticlesClient(Level world, BlockPos blockPos) {
        JadeVine.spawnParticlesClient(world, blockPos, (ParticleOptions)PastelParticleTypes.JADE_VINES_BLOOM);
        RandomSource random = world.random;
        double x = (double)blockPos.getX() + 0.2 + (double)random.nextFloat() * 0.6;
        double y = (double)blockPos.getY() + 0.2 + (double)random.nextFloat() * 0.6;
        double z = (double)blockPos.getZ() + 0.2 + (double)random.nextFloat() * 0.6;
        world.addParticle((ParticleOptions)ColoredFallingSporeBlossomParticleEffect.PINK, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnParticlesClient(Level world, BlockPos blockPos) {
        JadeVine.spawnParticlesClient(world, blockPos, (ParticleOptions)PastelParticleTypes.JADE_VINES);
    }

    private static void spawnParticlesClient(Level world, BlockPos blockPos, ParticleOptions particleType) {
        RandomSource random = world.random;
        double x = (double)blockPos.getX() + 0.2 + (double)random.nextFloat() * 0.6;
        double y = (double)blockPos.getY() + 0.2 + (double)random.nextFloat() * 0.6;
        double z = (double)blockPos.getZ() + 0.2 + (double)random.nextFloat() * 0.6;
        double velX = 0.06 - (double)random.nextFloat() * 0.12;
        double velY = 0.06 - (double)random.nextFloat() * 0.12;
        double velZ = 0.06 - (double)random.nextFloat() * 0.12;
        world.addParticle(particleType, x, y, z, velX, velY, velZ);
    }

    public static void spawnParticlesServer(ServerLevel world, BlockPos blockPos, int amount) {
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, Vec3.atCenterOf((Vec3i)blockPos), (ParticleOptions)PastelParticleTypes.JADE_VINES, amount, new Vec3(0.6, 0.6, 0.6), new Vec3(0.12, 0.12, 0.12));
    }

    public static boolean isExposedToSunlight(@NotNull Level world, @NotNull BlockPos blockPos) {
        return world.getBrightness(LightLayer.SKY, blockPos) > 8 && TimeHelper.isBrightSunlight(world);
    }

    public boolean setToAge(Level var1, BlockPos var2, int var3);
}

