/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.item_bowl;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.color.ColorRegistry;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.blocks.InWorldInteractionBlockEntity;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.events.game.ExactPositionSource;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.ColorTransmissionPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import earth.terrarium.pastel.particle.effect.ColoredTransmission;
import earth.terrarium.pastel.particle.effect.ColoredTransmissionParticleEffect;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemBowlBlockEntity
extends InWorldInteractionBlockEntity
implements SidedCapabilityProvider {
    protected static final int INVENTORY_SIZE = 1;

    public ItemBowlBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.ITEM_BOWL.get(), pos, state, 1);
        this.inventory.addListener(i -> this.setChanged());
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        this.unpackLootTable(null);
        return super.getUpdateTag(registryLookup);
    }

    public static void clientTick(@NotNull Level world, BlockPos blockPos, BlockState blockState, ItemBowlBlockEntity itemBowlBlockEntity) {
        Optional<InkColor> optionalItemColor;
        ItemStack storedStack = itemBowlBlockEntity.getItem(0);
        if (!storedStack.isEmpty() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(storedStack.getItem())).isPresent()) {
            int particleCount = Support.chanceRound(Math.max(0.1, (double)((float)storedStack.getCount() / (float)(storedStack.getMaxStackSize() * 2))), world.random);
            ItemBowlBlockEntity.spawnRisingParticles(world, blockPos, storedStack, particleCount);
        }
    }

    public static void spawnRisingParticles(Level world, BlockPos blockPos, ItemStack itemStack, int amount) {
        Optional<InkColor> optionalItemColor;
        if (amount > 0 && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(itemStack.getItem())).isPresent()) {
            ParticleOptions particleEffect = ColoredSparkleRisingParticleEffect.of(optionalItemColor.get().getColorInt());
            for (int i = 0; i < amount; ++i) {
                float randomX = 0.1f + world.random.nextFloat() * 0.8f;
                float randomZ = 0.1f + world.random.nextFloat() * 0.8f;
                world.addParticle(particleEffect, (double)((float)blockPos.getX() + randomX), (double)blockPos.getY() + 0.75, (double)((float)blockPos.getZ() + randomZ), 0.0, 0.05, 0.0);
            }
        }
    }

    public int decrementBowlStack(Vec3 orbTargetPos, int amount, boolean doEffects) {
        ItemStack storedStack = this.getItem(0);
        if (storedStack.isEmpty() || this.level == null) {
            return 0;
        }
        int decrementAmount = Math.min(amount, storedStack.getCount());
        ItemStack remainder = storedStack.getCraftingRemainingItem();
        if (!remainder.isEmpty()) {
            if (storedStack.getCount() == 1) {
                this.setItem(0, remainder);
            } else {
                this.getItem(0).shrink(decrementAmount);
                remainder.setCount(decrementAmount);
                ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5, remainder);
                itemEntity.push(0.0, 0.1, 0.0);
                this.level.addFreshEntity((Entity)itemEntity);
            }
        } else {
            this.getItem(0).shrink(decrementAmount);
        }
        if (decrementAmount > 0) {
            if (doEffects) {
                this.spawnOrbParticles(orbTargetPos);
            }
            this.updateInClientWorld();
            this.setChanged();
        }
        return decrementAmount;
    }

    public void spawnOrbParticles(Vec3 orbTargetPos) {
        ItemStack storedStack = this.getItem(0);
        if (!storedStack.isEmpty() && this.level != null) {
            InkColor itemColor = ColorRegistry.ITEM_COLORS.getMapping(storedStack.getItem(), InkColors.PURPLE);
            ParticleOptions sparkleRisingParticleEffect = ColoredSparkleRisingParticleEffect.of(itemColor.getColorInt());
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)this.level, new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5), sparkleRisingParticleEffect, 50, new Vec3(0.4, 0.2, 0.4), new Vec3(0.06, 0.16, 0.06));
                ColorTransmissionPayload.playColorTransmissionParticle(serverWorld, new ColoredTransmission(new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5), new ExactPositionSource(orbTargetPos), 20, itemColor.getColorInt()));
            } else {
                level = this.getLevel();
                if (level instanceof ClientLevel) {
                    ClientLevel clientWorld = (ClientLevel)level;
                    for (int i = 0; i < 50; ++i) {
                        float randomOffsetX = (float)this.worldPosition.getX() + 0.3f + this.level.random.nextFloat() * 0.6f;
                        float randomOffsetY = (float)this.worldPosition.getY() + 0.3f + this.level.random.nextFloat() * 0.6f;
                        float randomOffsetZ = (float)this.worldPosition.getZ() + 0.3f + this.level.random.nextFloat() * 0.6f;
                        float randomVelocityX = 0.03f - this.level.random.nextFloat() * 0.06f;
                        float randomVelocityY = this.level.random.nextFloat() * 0.16f;
                        float randomVelocityZ = 0.03f - this.level.random.nextFloat() * 0.06f;
                        clientWorld.addParticle(sparkleRisingParticleEffect, (double)randomOffsetX, (double)randomOffsetY, (double)randomOffsetZ, (double)randomVelocityX, (double)randomVelocityY, (double)randomVelocityZ);
                    }
                    ColoredTransmissionParticleEffect sphereParticleEffect = new ColoredTransmissionParticleEffect(new ExactPositionSource(orbTargetPos), 20, itemColor.getColorInt());
                    clientWorld.addParticle((ParticleOptions)sphereParticleEffect, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, (orbTargetPos.x() - (double)this.worldPosition.getX()) * 0.045, 0.0, (orbTargetPos.z() - (double)this.worldPosition.getZ()) * 0.045);
                }
            }
            this.level.playSound(null, this.worldPosition, PastelSounds.CRAFTING_DING, SoundSource.BLOCKS, PastelCommon.CONFIG.BlockSoundVolume, 0.7f + this.level.random.nextFloat() * 0.6f);
        }
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return this.inventory;
    }
}

