/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RandomTeleportingIdolBlock
extends IdolBlock {
    protected final int horizontalRange;
    protected final int verticalRange;

    public RandomTeleportingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, int horizontalRange, int verticalRange) {
        super(settings, particleEffect);
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
    }

    public MapCodec<? extends RandomTeleportingIdolBlock> codec() {
        return null;
    }

    public static void teleportTo(ServerLevel world, Entity entity, int x, int y, int z) {
        RandomTeleportingIdolBlock.teleportTo(world, entity, new BlockPos(x, y, z));
    }

    public static boolean teleportTo(ServerLevel world, Entity entity, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        while (mutable.getY() < world.getMaxBuildHeight() && world.getBlockState((BlockPos)mutable).blocksMotion()) {
            mutable.move(Direction.UP);
        }
        while (mutable.getY() > world.getMinBuildHeight() && !world.getBlockState((BlockPos)mutable).blocksMotion()) {
            mutable.move(Direction.DOWN);
        }
        BlockState blockState = world.getBlockState((BlockPos)mutable);
        if (blockState.blocksMotion()) {
            double boundingBoxY = entity.getBoundingBox().getYsize();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                serverPlayerEntity.teleportTo((ServerLevel)serverPlayerEntity.level(), (double)mutable.getX() + 0.5, (double)mutable.getY() + boundingBoxY, (double)mutable.getZ() + 0.5, serverPlayerEntity.getYRot(), serverPlayerEntity.getXRot());
                world.broadcastEntityEvent((Entity)serverPlayerEntity, (byte)18);
                return true;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                boolean success = livingEntity.randomTeleport((double)mutable.getX() + 0.5, (double)mutable.getY() + boundingBoxY, (double)mutable.getZ() + 0.5, true);
                if (success) {
                    world.playSound(null, entity.xo, entity.yo, entity.zo, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    entity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
                return success;
            }
            entity.teleportTo((double)mutable.getX() + 0.5, (double)mutable.getY() + boundingBoxY, (double)mutable.getZ() + 0.5);
            world.playSound(null, entity.xo, entity.yo, entity.zo, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            entity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.random_teleporting_idol.tooltip", (Object[])new Object[]{this.horizontalRange}));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        if (entity != null) {
            RandomSource random = world.getRandom();
            int x = (int)((double)blockPos.getX() + (random.nextDouble() - 0.5) * (double)(this.horizontalRange + this.horizontalRange));
            int y = blockPos.getY() + (random.nextInt(this.verticalRange + this.verticalRange) - this.verticalRange);
            int z = (int)((double)blockPos.getZ() + (random.nextDouble() - 0.5) * (double)(this.horizontalRange + this.horizontalRange));
            RandomTeleportingIdolBlock.teleportTo(world, entity, x, y, z);
            return true;
        }
        return false;
    }
}

