/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ExplosionIdolBlock
extends IdolBlock {
    protected final float power;
    protected final boolean createFire;
    protected final Explosion.BlockInteraction destructionType;

    public ExplosionIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, float power, boolean createFire, Explosion.BlockInteraction destructionType) {
        super(settings, particleEffect);
        this.power = power;
        this.createFire = createFire;
        this.destructionType = destructionType;
    }

    public MapCodec<? extends ExplosionIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.explosion_idol.tooltip", (Object[])new Object[]{Float.valueOf(this.power)}));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        world.explode(null, world.damageSources().explosion(entity, null), (ExplosionDamageCalculator)new SpareBlockExplosionBehavior(blockPos), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, this.power + 1.0f, this.createFire, Level.ExplosionInteraction.BLOCK);
        return true;
    }

    private static class SpareBlockExplosionBehavior
    extends ExplosionDamageCalculator {
        public final BlockPos sparedPos;

        public SpareBlockExplosionBehavior(BlockPos sparedPos) {
            this.sparedPos = sparedPos;
        }

        public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float power) {
            return !pos.equals((Object)this.sparedPos) && super.shouldBlockExplode(explosion, world, pos, state, power);
        }
    }
}

