/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fusion_shrine;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.InWorldInteractionBlock;
import earth.terrarium.pastel.blocks.fusion_shrine.FusionShrineBlockEntity;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelMultiblocks;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class FusionShrineBlock
extends InWorldInteractionBlock {
    public static final MapCodec<FusionShrineBlock> CODEC = FusionShrineBlock.simpleCodec(FusionShrineBlock::new);
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("collect_all_basic_pigments_besides_brown");
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.create((String)"light_level", (int)0, (int)15);
    protected static final VoxelShape SHAPE;

    public FusionShrineBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends FusionShrineBlock> codec() {
        return CODEC;
    }

    public static void clearCurrentlyRenderedMultiBlock(Level world) {
        if (world.isClientSide && world.isClientSide()) {
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.FUSION_SHRINE));
        }
    }

    public static boolean verifySkyAccess(ServerLevel world, BlockPos shrinePos) {
        if (world.getBlockState(shrinePos.above()).isRedstoneConductor((BlockGetter)world, shrinePos.above())) {
            world.playSound(null, shrinePos, PastelSounds.USE_FAIL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, shrinePos.above().getCenter(), ColoredSparkleRisingParticleEffect.RED, 8, Vec3.ZERO, new Vec3(0.1, 0.1, 0.1));
            return false;
        }
        int topY = world.getHeight(Heightmap.Types.WORLD_SURFACE, shrinePos.getX(), shrinePos.getZ());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(shrinePos.getX(), topY, shrinePos.getZ());
        for (int y = topY; y > shrinePos.getY(); --y) {
            mutablePos.setY(y - 1);
            BlockState posState = world.getBlockState((BlockPos)mutablePos);
            if (posState.getLightBlock((BlockGetter)world, (BlockPos)mutablePos) > 0) break;
        }
        if (mutablePos.getY() == shrinePos.getY()) {
            return true;
        }
        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity(world, new Vec3((double)shrinePos.getX() + 0.5, (double)(shrinePos.getY() + 1), (double)shrinePos.getZ() + 0.5), ColoredSparkleRisingParticleEffect.RED, 1, new Vec3(0.0, 0.5, 0.0));
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, new Vec3((double)shrinePos.getX() + 0.5, (double)topY - 0.5, (double)shrinePos.getZ() + 0.5), ColoredSparkleRisingParticleEffect.RED, 8, Vec3.ZERO, new Vec3(0.1, 0.1, 0.1));
        world.playSound(null, shrinePos, PastelSounds.USE_FAIL, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return false;
    }

    public static boolean verifyStructure(Level level, BlockPos blockPos, @Nullable ServerPlayer serverPlayerEntity) {
        Multiblock multiblock = PastelMultiblocks.get(PastelMultiblocks.FUSION_SHRINE);
        boolean valid = multiblock.validate(level, blockPos.below(), Rotation.NONE);
        if (valid) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                Support.mbCriterion(sl, blockPos, multiblock);
            }
        } else if (level.isClientSide) {
            ModonomiconHelper.renderMultiblock(multiblock, PastelMultiblocks.FUSION_SHRINE_TEXT, blockPos.below(2), Rotation.NONE);
        } else {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof FusionShrineBlockEntity) {
                FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
                fusionShrineBlockEntity.scatterContents(level);
            }
        }
        return valid;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIGHT_LEVEL});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FusionShrineBlockEntity(pos, state);
    }

    @Override
    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity blockEntity2 = (FusionShrineBlockEntity)blockEntity;
            FriendlyStackHandler inventory = blockEntity2.getInventory();
            int i = 0;
            float f = 0.0f;
            for (int j = 0; j < inventory.getSlots(); ++j) {
                ItemStack itemStack = blockEntity2.getItem(j);
                if (itemStack.isEmpty()) continue;
                f += (float)itemStack.getCount() / (float)Math.min(blockEntity2.getMaxStackSize(), itemStack.getMaxStackSize());
                ++i;
            }
            if (blockEntity2.tank.getFluidAmount() > 0) {
                f += (float)blockEntity2.tank.getFluidAmount() / (float)blockEntity2.tank.getCapacity();
                ++i;
            }
            return Mth.floor((float)(f / ((float)inventory.getSlots() + 1.0f) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            FusionShrineBlock.clearCurrentlyRenderedMultiBlock((Level)world);
        }
    }

    @Override
    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.isClientSide) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (blockEntity instanceof FusionShrineBlockEntity) {
                    FusionShrineBlockEntity shrine = (FusionShrineBlockEntity)blockEntity;
                    ItemStack itemStack = itemEntity.getItem();
                    Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
                    if (fluidHandler.isPresent()) {
                        FluidUtil.tryFluidTransfer((IFluidHandler)shrine.tank, (IFluidHandler)((IFluidHandler)fluidHandler.get()), (int)1000, (boolean)true);
                    } else {
                        itemEntity.setItem(ItemHandlerHelper.insertItemStacked((IItemHandler)shrine.getInventory(), (ItemStack)itemStack, (boolean)false));
                    }
                }
            }
            if (entity.position().x % 0.5 != 0.0 && entity.position().z % 0.5 != 0.0) {
                super.fallOn(world, state, pos, entity, fallDistance);
            }
        }
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            FusionShrineBlock.verifyStructure(world, pos, null);
            return ItemInteractionResult.SUCCESS;
        }
        FusionShrineBlock.verifySkyAccess((ServerLevel)world, pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity shrine = (FusionShrineBlockEntity)blockEntity;
            if (FusionShrineBlock.verifyStructure(world, pos, (ServerPlayer)player)) {
                shrine.setOwner(player);
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)shrine.getTank())) {
                    shrine.inventoryChanged = true;
                    shrine.setLightForFluid(pos, shrine.getTank().getFluid());
                    shrine.updateInClientWorld();
                    return ItemInteractionResult.CONSUME;
                }
                if ((player.isShiftKeyDown() || handStack.isEmpty()) && this.retrieveLastStack(world, pos, player, hand, handStack, shrine)) {
                    shrine.inventoryChanged = true;
                    return ItemInteractionResult.CONSUME;
                }
                if (!handStack.isEmpty() && this.inputHandStack(world, player, hand, handStack, shrine)) {
                    shrine.inventoryChanged = true;
                    return ItemInteractionResult.CONSUME;
                }
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return FusionShrineBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.FUSION_SHRINE.get()), (BlockEntityTicker)(world.isClientSide ? FusionShrineBlockEntity::clientTick : FusionShrineBlockEntity::serverTick));
    }

    static {
        VoxelShape neck = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
        VoxelShape head = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        VoxelShape crystal = Block.box((double)6.5, (double)13.0, (double)6.5, (double)9.5, (double)23.0, (double)9.5);
        neck = Shapes.or((VoxelShape)neck, (VoxelShape)head);
        SHAPE = Shapes.or((VoxelShape)neck, (VoxelShape)crystal);
    }
}

