/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PastelFluidBlock
extends LiquidBlock {
    public final BlockState ultrawarmReplacementBlockState;

    public PastelFluidBlock(PastelFluid fluid, BlockState ultrawarmReplacementBlockState, BlockBehaviour.Properties settings) {
        super((FlowingFluid)fluid, settings);
        this.ultrawarmReplacementBlockState = ultrawarmReplacementBlockState;
    }

    public abstract SimpleParticleType getSplashParticle();

    public abstract Tuple<SimpleParticleType, SimpleParticleType> getFishingParticles();

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        ((PastelFluid)this.fluid).onEntityCollision(state, world, pos, entity);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (this.shouldSpreadLiquid(world, pos, state)) {
            world.scheduleTick(pos, state.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)world));
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (world.dimensionType().ultraWarm()) {
            world.setBlockAndUpdate(pos, this.ultrawarmReplacementBlockState);
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.shouldSpreadLiquid(world, pos, state)) {
            world.scheduleTick(pos, state.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)world));
        }
        super.onPlace(state, world, pos, oldState, notify);
    }

    @Nullable
    public abstract BlockState handleFluidCollision(Level var1, @NotNull FluidState var2, @NotNull FluidState var3);

    public void fireExtinguishEvent(LevelAccessor world, BlockPos pos) {
        world.levelEvent(1501, pos, 0);
    }

    public boolean shouldSpreadLiquid(Level world, BlockPos pos, BlockState state) {
        FluidState fluidState = state.getFluidState();
        if (fluidState == null || fluidState.isEmpty()) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            BlockState setState;
            FluidState otherState = world.getFluidState(pos.relative(direction));
            if (otherState == null || otherState.isEmpty() || (setState = this.handleFluidCollision(world, fluidState, otherState)) == null) continue;
            this.fireExtinguishEvent((LevelAccessor)world, pos);
            world.setBlockAndUpdate(pos, setState);
            return false;
        }
        return true;
    }
}

