/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.jade_vines.JadeVinePlantBlock;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEntityTypeTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class SawbladeHollyBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<SawbladeHollyBushBlock> CODEC = SawbladeHollyBushBlock.simpleCodec(SawbladeHollyBushBlock::new);
    public static final float DAMAGE = 2.0f;
    public static final int MAX_TINY_AGE = 0;
    public static final int MAX_SMALL_AGE = 2;
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    private static final VoxelShape SMALL_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape LARGE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public SawbladeHollyBushBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends SawbladeHollyBushBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 7;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 7 && random.nextInt(5) == 0 && world.getRawBrightness(pos.above(), 0) >= 9) {
            BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            world.setBlock(pos, blockState, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if ((Integer)state.getValue((Property)AGE) == 0) {
            return;
        }
        if (entity instanceof LivingEntity && !entity.getType().is(PastelEntityTypeTags.POKING_DAMAGE_IMMUNE)) {
            entity.makeStuckInBlock(state, new Vec3(0.8, 0.75, 0.8));
            if (!(world.isClientSide || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
                double difX = Math.abs(entity.getX() - entity.xOld);
                double difZ = Math.abs(entity.getZ() - entity.zOld);
                if (difX >= 0.003 || difZ >= 0.003) {
                    entity.hurt(PastelDamageTypes.bristeSprouts(world), 2.0f);
                }
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)PastelItems.SAWBLADE_HOLLY_BERRY.get());
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(PastelBlockTags.SAWBLADE_HOLLY_PLANTABLE);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) <= 0) {
            return SMALL_SHAPE;
        }
        return (Integer)state.getValue((Property)AGE) <= 2 ? LARGE_SHAPE : super.getShape(state, world, pos, context);
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int age = (Integer)state.getValue((Property)AGE);
        if (SawbladeHollyBushBlock.canBeSheared(age) && handStack.is(Tags.Items.TOOLS_SHEAR)) {
            if (!world.isClientSide) {
                for (ItemStack stack : JadeVinePlantBlock.getHarvestedStacks(state, (ServerLevel)world, pos, world.getBlockEntity(pos), (Entity)player, player.getMainHandItem(), PastelLootTables.SAWBLADE_HOLLY_SHEARING)) {
                    SawbladeHollyBushBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
                }
                handStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) - 1));
            world.setBlock(pos, newState, 2);
            world.gameEvent((Holder)GameEvent.SHEAR, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            world.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (age == 7) {
            if (!world.isClientSide) {
                for (ItemStack stack : JadeVinePlantBlock.getHarvestedStacks(state, (ServerLevel)world, pos, world.getBlockEntity(pos), (Entity)player, player.getMainHandItem(), PastelLootTables.SAWBLADE_HOLLY_HARVESTING)) {
                    SawbladeHollyBushBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
                }
            }
            world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(4));
            world.setBlock(pos, newState, 2);
            world.gameEvent((Holder)GameEvent.SHEAR, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(handStack, state, world, pos, player, hand, hit);
    }

    public static boolean canBeSheared(int age) {
        return age > 2;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 7;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int newAge = Math.min(7, (Integer)state.getValue((Property)AGE) + (random.nextBoolean() ? 1 : 2));
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DAMAGE_OTHER;
    }
}

