/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.deeper_down.flora.MossBallBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GiantMossBallBlock
extends MossBallBlock {
    public static final MapCodec<GiantMossBallBlock> CODEC = GiantMossBallBlock.simpleCodec(GiantMossBallBlock::new);

    public GiantMossBallBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && entity.getType() != EntityType.FOX && entity.getType() != EntityType.BEE) {
            entity.makeStuckInBlock(state, new Vec3((double)0.9f, 0.334, (double)0.9f));
        }
    }

    @Override
    public float getMaxHorizontalOffset() {
        return 0.1f;
    }

    @Override
    public float getMaxVerticalOffset() {
        return 0.25f;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(world, pos);
        return Shapes.block().move(vec3d.x, vec3d.y, vec3d.z);
    }
}

