/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class DoomBloomBlock
extends FlowerBlock
implements BonemealableBlock {
    public static final MapCodec<DoomBloomBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)EFFECTS_FIELD.forGetter(FlowerBlock::getSuspiciousEffects), (App)DoomBloomBlock.propertiesCodec()).apply((Applicative)i, DoomBloomBlock::new));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final int AGE_MAX = 4;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0);
    protected static final double GROW_CHANCE = 0.2;

    public DoomBloomBlock(Holder<MobEffect> suspiciousStewEffect, int effectDuration, BlockBehaviour.Properties settings) {
        this(DoomBloomBlock.makeEffectList(suspiciousStewEffect, (float)effectDuration), settings);
    }

    public DoomBloomBlock(SuspiciousStewEffects stewEffects, BlockBehaviour.Properties settings) {
        super(stewEffects, settings);
    }

    public MapCodec<? extends DoomBloomBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(PastelBlockTags.DOOMBLOOM_PLANTABLE);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if ((double)random.nextFloat() > 0.2) {
            this.performBonemeal(world, random, pos, state);
        }
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age < 4) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                world.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            Block.updateOrDestroy((BlockState)state, (BlockState)Blocks.AIR.defaultBlockState(), (LevelAccessor)world, (BlockPos)pos, (int)10, (int)512);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if ((Integer)state.getValue((Property)AGE) == 4) {
            int r = random.nextInt(100);
            if (r < 16) {
                double posX = (double)pos.getX() + 0.25 + random.nextDouble() * 0.5;
                double posY = (double)pos.getY() + random.nextDouble() * 0.5;
                double posZ = (double)pos.getZ() + 0.25 + random.nextDouble() * 0.5;
                world.addParticle((ParticleOptions)ParticleTypes.LAVA, posX, posY, posZ, 0.0, 0.0, 0.0);
                if (r < 2) {
                    world.playLocalSound(posX, posY, posZ, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
            }
            if (random.nextInt(100) == 0) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    protected void onExplosionHit(BlockState state, Level world, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackMerger) {
        DoomBloomBlock.explode(world, pos, state);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        double velocity;
        if (!world.isClientSide() && ((velocity = entity.getDeltaMovement().length()) > 0.235 && (double)world.random.nextInt(20) <= velocity * 20.0 || entity.isOnFire())) {
            DoomBloomBlock.explode(world, pos, state);
        }
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        super.onProjectileHit(world, state, hit, projectile);
        DoomBloomBlock.explode(world, hit.getBlockPos(), state);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (world.random.nextInt(10) == 0) {
            DoomBloomBlock.explode(world, pos, state);
        }
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(world, player, pos, state, blockEntity, stack);
        if (Ench.getLevel((HolderLookup.Provider)world.registryAccess(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, stack) == 0 && !stack.is(Tags.Items.TOOLS_SHEAR)) {
            DoomBloomBlock.explode(world, pos, state);
        }
    }

    protected static void explode(Level world, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) == 4) {
            world.removeBlock(pos, false);
            world.explode(null, PastelDamageTypes.incandescence(world), new ExplosionDamageCalculator(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f, true, Level.ExplosionInteraction.BLOCK);
            if (!world.isClientSide) {
                DoomBloomBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)PastelItems.DOOMBLOOM_SEED.get(), world.random.nextIntBetweenInclusive(3, 7)));
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 4) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
            int randomCount = world.random.nextIntBetweenInclusive(2, 3);
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.GUNPOWDER, randomCount));
            world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 0.9f + world.random.nextFloat() * 0.2f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

