/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PastelBedBlock
extends BedBlock {
    protected static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});

    public PastelBedBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = PastelBedBlock.getConnectedDirection((BlockState)state).getOpposite();
        return switch (direction) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }
}

