/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.energy.color.InkColor;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GlowBlock
extends Block {
    public static final MapCodec<GlowBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)GlowBlock.propertiesCodec(), (App)InkColor.CODEC.fieldOf("color").forGetter(GlowBlock::getColor)).apply((Applicative)i, GlowBlock::new));
    private static final Map<InkColor, GlowBlock> GLOWBLOCKS = new Object2ObjectArrayMap();
    protected final InkColor color;

    public GlowBlock(BlockBehaviour.Properties settings, InkColor color) {
        super(settings);
        this.color = color;
        GLOWBLOCKS.put(color, this);
    }

    public MapCodec<? extends GlowBlock> codec() {
        return CODEC;
    }

    public InkColor getColor() {
        return this.color;
    }

    public static GlowBlock byColor(InkColor color) {
        return GLOWBLOCKS.get(color);
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }
}

