/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class DiagonalBlock
extends Block {
    public static final MapCodec<DiagonalBlock> CODEC = DiagonalBlock.simpleCodec(DiagonalBlock::new);
    public static final BooleanProperty DIAGONAL = BooleanProperty.create((String)"diagonal");

    public DiagonalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DIAGONAL, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends DiagonalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        Player player = ctx.getPlayer();
        if (player != null && state != null) {
            float yaw = player.getYRot() + 180.0f + 360.0f;
            float arc = yaw % 90.0f;
            return (BlockState)state.setValue((Property)DIAGONAL, (Comparable)Boolean.valueOf(arc > 25.0f && arc < 65.0f));
        }
        return super.getStateForPlacement(ctx);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DIAGONAL});
    }
}

