/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.decoration.WandLightBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DecayingLightBlock
extends WandLightBlock {
    public static final MapCodec<DecayingLightBlock> CODEC = DecayingLightBlock.simpleCodec(DecayingLightBlock::new);

    public DecayingLightBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        int light = (Integer)state.getValue((Property)LightBlock.LEVEL);
        if (light < 2) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                world.setBlock(pos, Blocks.WATER.defaultBlockState(), 3);
            } else {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        } else {
            world.setBlock(pos, (BlockState)state.setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(light - 1)), 3);
        }
    }
}

