/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.crystallarieum;

import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.storage.IndividualCappedInkStorage;
import earth.terrarium.pastel.blocks.InWorldInteractionBlockEntity;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.helpers.interaction.TickLooper;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumCatalyst;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumRecipe;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.render.animation.FlowAnimator;
import earth.terrarium.pastel.render.animation.FlowData;
import earth.terrarium.pastel.render.animation.FlowHandlers;
import earth.terrarium.pastel.render.animation.FlowStates;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystallarieumBlockEntity
extends InWorldInteractionBlockEntity
implements PlayerOwned,
InkStorageBlockEntity<IndividualCappedInkStorage>,
SidedCapabilityProvider {
    private static final FlowAnimator.Factory<CrystallarieumBlockEntity> FACTORY;
    protected static final int CATALYST_SLOT_ID = 0;
    protected static final int INK_STORAGE_STACK_SLOT_ID = 1;
    protected static final int INVENTORY_SIZE = 2;
    public static final long INK_STORAGE_SIZE = 409600L;
    protected IndividualCappedInkStorage inkStorage;
    protected boolean inkDirty;
    @Nullable
    protected UUID ownerUUID;
    @Nullable
    protected RecipeHolder<CrystallarieumRecipe> currentRecipe;
    protected CrystallarieumCatalyst currentCatalyst = CrystallarieumCatalyst.EMPTY;
    protected FluidTank tank = new FluidTank(1000);
    public static final int SECOND = 20;
    protected TickLooper tickLooper = new TickLooper(20);
    protected int currentGrowthStageTicks;
    protected boolean canWork;
    float rotation = 0.0f;
    protected FlowAnimator animator;
    @NotNull
    protected FlowData<Float> _alpha = FlowData.NULL();
    @NotNull
    protected FlowData<Float> _speed = FlowData.NULL();
    @NotNull
    protected FlowData<Float> _bounce = FlowData.NULL();

    public CrystallarieumBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.CRYSTALLARIEUM.get(), pos, state, 2);
        this.inventory.addListener(i -> this.inventoryChanged());
        this.inkStorage = new IndividualCappedInkStorage(409600L);
        this.canWork = true;
    }

    public static void clientTick(@NotNull Level world, BlockPos blockPos, BlockState blockState, CrystallarieumBlockEntity crystallarieum) {
        if (crystallarieum.animator == null) {
            crystallarieum.animator = FACTORY.create(FlowStates.INIT, crystallarieum);
        } else {
            crystallarieum.updateAnimator();
        }
        if (crystallarieum.canWork && crystallarieum.currentRecipe != null) {
            ParticleOptions particleEffect = ColoredSparkleRisingParticleEffect.of(((CrystallarieumRecipe)crystallarieum.currentRecipe.value()).getInkColor().getColorInt());
            int amount = 1 + ((CrystallarieumRecipe)crystallarieum.currentRecipe.value()).getInkPerSecond();
            if (Support.chanceRound((double)amount / 80.0, world.random) > 0) {
                double randomX = world.getRandom().nextDouble() * 0.8;
                double randomZ = world.getRandom().nextDouble() * 0.8;
                world.addAlwaysVisibleParticle(particleEffect, (double)blockPos.getX() + 0.1 + randomX, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.1 + randomZ, 0.0, 0.03, 0.0);
            }
        }
    }

    public void updateAnimator() {
        if (this.currentRecipe == null) {
            this.animator.swapState(FlowStates.INACTIVE);
        } else if (FluidStack.isSameFluid((FluidStack)this.tank.getFluid(), (FluidStack)((CrystallarieumRecipe)this.currentRecipe.value()).getFluidMedium()) && this.inkStorage.getEnergy(((CrystallarieumRecipe)this.currentRecipe.value()).getInkColor()) > 0L) {
            this.animator.swapState(FlowStates.ACTIVE);
        } else {
            this.animator.swapState(FlowStates.IDLE);
        }
        this.animator.tick();
    }

    public static void serverTick(@NotNull Level world, BlockPos blockPos, BlockState blockState, CrystallarieumBlockEntity crystallarieum) {
        if (crystallarieum.canWork) {
            CrystallarieumBlockEntity.transferInk(crystallarieum);
            RecipeHolder<CrystallarieumRecipe> recipe = crystallarieum.currentRecipe;
            if (recipe != null) {
                crystallarieum.tickLooper.tick();
                if (crystallarieum.tickLooper.reachedCap()) {
                    CrystallarieumBlockEntity.tickRecipe(world, blockPos, crystallarieum, recipe);
                    crystallarieum.tickLooper.reset();
                }
            }
        }
    }

    private static void tickRecipe(@NotNull Level level, BlockPos blockPos, CrystallarieumBlockEntity crystal, @NotNull RecipeHolder<CrystallarieumRecipe> recipe) {
        if (crystal.currentCatalyst == CrystallarieumCatalyst.EMPTY && !((CrystallarieumRecipe)recipe.value()).growsWithoutCatalyst()) {
            return;
        }
        if (!FluidStack.isSameFluid((FluidStack)crystal.tank.getFluid(), (FluidStack)((CrystallarieumRecipe)recipe.value()).getFluidMedium()) || crystal.inkStorage.getEnergy(((CrystallarieumRecipe)recipe.value()).getInkColor()) == 0L) {
            if (crystal.canWork) {
                crystal.canWork = false;
            }
            return;
        }
        float consumedInkFloat = (float)((CrystallarieumRecipe)recipe.value()).getInkPerSecond() * crystal.currentCatalyst.growthAccelerationMod() * crystal.currentCatalyst.inkConsumptionMod();
        int consumedInt = Support.chanceRound(consumedInkFloat, level.random);
        if (crystal.inkStorage.drainEnergy(((CrystallarieumRecipe)recipe.value()).getInkColor(), consumedInt) < (long)consumedInt) {
            crystal.canWork = false;
            crystal.setInkDirty();
            crystal.updateInClientWorld();
            return;
        }
        crystal.setInkDirty();
        crystal.currentGrowthStageTicks += (int)(20.0f * crystal.currentCatalyst.growthAccelerationMod());
        if (level.random.nextFloat() < crystal.currentCatalyst.consumeChancePerSecond()) {
            ItemStack catalystStack = crystal.getItem(0);
            catalystStack.shrink(1);
            crystal.updateInClientWorld();
            if (catalystStack.isEmpty()) {
                crystal.currentCatalyst = CrystallarieumCatalyst.EMPTY;
                if (!((CrystallarieumRecipe)recipe.value()).growsWithoutCatalyst()) {
                    crystal.canWork = false;
                }
            }
        }
        if (crystal.currentGrowthStageTicks >= ((CrystallarieumRecipe)recipe.value()).getSecondsPerGrowthStage() * 20) {
            BlockPos topPos = blockPos.above();
            BlockState topState = level.getBlockState(topPos);
            Optional<BlockState> nextState = ((CrystallarieumRecipe)recipe.value()).getNextState(recipe, topState);
            if (nextState.isPresent()) {
                level.setBlockAndUpdate(topPos, nextState.get());
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    Support.areaCriterion(sl, 12, blockPos, Optional.empty(), p -> PastelCriteria.CRYSTALLARIEUM_GROWING.trigger((ServerPlayer)p, sl, topPos, crystal.getItem(0)));
                }
            } else {
                crystal.canWork = false;
            }
            crystal.currentGrowthStageTicks = 0;
        }
    }

    private static void transferInk(CrystallarieumBlockEntity crystallarieum) {
        InkStorageItem inkStorageItem;
        Object itemInkStorage;
        long transferredAmount;
        ItemStack inkStorageStack = crystallarieum.getItem(1);
        Item item = inkStorageStack.getItem();
        if (item instanceof InkStorageItem && (transferredAmount = InkStorage.transferInk(itemInkStorage = (inkStorageItem = (InkStorageItem)item).getEnergyStorage(inkStorageStack), crystallarieum.inkStorage)) > 0L) {
            inkStorageItem.setEnergyStorage(inkStorageStack, (InkStorage)itemInkStorage);
        }
    }

    public void inventoryChanged() {
        if (this.currentRecipe == null || this.level == null) {
            this.currentCatalyst = CrystallarieumCatalyst.EMPTY;
            this.canWork = false;
        } else {
            this.currentCatalyst = ((CrystallarieumRecipe)this.currentRecipe.value()).getCatalyst(this.getItem(0));
            BlockState topState = this.level.getBlockState(this.worldPosition.above());
            this.canWork = ((CrystallarieumRecipe)this.currentRecipe.value()).getNextState(this.currentRecipe, topState).isPresent() && (((CrystallarieumRecipe)this.currentRecipe.value()).growsWithoutCatalyst() || this.currentCatalyst != CrystallarieumCatalyst.EMPTY);
        }
        this.updateInClientWorld();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        CodecHelper.fromNbt(InkStorageComponent.CODEC, nbt.get("InkStorage")).ifPresent(storage -> {
            this.inkStorage = new IndividualCappedInkStorage(storage.maxPerColor(), storage.storedEnergy());
        });
        if (nbt.contains("Looper", 10)) {
            this.tickLooper = TickLooper.readNbt(nbt.getCompound("Looper"));
        }
        this.tank.readFromNBT(registryLookup, nbt);
        this.canWork = nbt.getBoolean("CanWork");
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentCatalyst = CrystallarieumCatalyst.EMPTY;
        this.currentRecipe = MultiblockCrafter.getRecipeEntryFromNbt(this.level, nbt, CrystallarieumRecipe.class);
        this.currentGrowthStageTicks = nbt.getInt("CurrentGrowthStageDuration");
        if (this.currentRecipe != null) {
            this.currentCatalyst = ((CrystallarieumRecipe)this.currentRecipe.value()).getCatalyst(this.getItem(0));
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        CodecHelper.writeNbt(nbt, "InkStorage", InkStorageComponent.CODEC, new InkStorageComponent(this.inkStorage));
        nbt.put("Looper", this.tickLooper.toNbt());
        this.tank.writeToNBT(registryLookup, nbt);
        nbt.putBoolean("CanWork", this.canWork);
        nbt.putInt("CurrentGrowthStageDuration", this.currentGrowthStageTicks);
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.putString("CurrentRecipe", this.currentRecipe.id().toString());
        }
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    public void acceptStack(ItemStack itemStack, boolean creative, @Nullable UUID player) {
        InkStorageItem inkStorageItem;
        boolean changed = false;
        if (this.level == null) {
            return;
        }
        Item item = itemStack.getItem();
        if (item instanceof InkStorageItem && (inkStorageItem = (InkStorageItem)item).getDrainability().canDrain(false)) {
            ItemStack currentInkStorageStack = this.getItem(1);
            if (currentInkStorageStack.isEmpty()) {
                this.setItem(1, itemStack.copy());
                if (!creative) {
                    itemStack.setCount(0);
                }
                changed = true;
            }
        } else if (this.level.getBlockState(this.worldPosition.above()).isAir()) {
            Optional recipe = this.level.getRecipeManager().getRecipeFor(PastelRecipeTypes.CRYSTALLARIEUM, (RecipeInput)new SingleRecipeInput(itemStack), this.level);
            if (recipe.isPresent()) {
                if (!creative) {
                    itemStack.shrink(1);
                }
                BlockState placedState = ((CrystallarieumRecipe)((RecipeHolder)recipe.get()).value()).getGrowthStages().getFirst();
                this.level.setBlockAndUpdate(this.worldPosition.above(), placedState);
                this.onTopBlockChange(placedState, (RecipeHolder<CrystallarieumRecipe>)((RecipeHolder)recipe.get()));
                changed = true;
            }
        } else if (this.currentRecipe != null) {
            ItemStack currentCatalystStack = this.getItem(0);
            if (currentCatalystStack.isEmpty()) {
                CrystallarieumCatalyst catalyst = ((CrystallarieumRecipe)this.currentRecipe.value()).getCatalyst(itemStack);
                if (catalyst != CrystallarieumCatalyst.EMPTY) {
                    this.setItem(0, itemStack.copy());
                    if (!creative) {
                        itemStack.setCount(0);
                    }
                    this.currentCatalyst = catalyst;
                    changed = true;
                }
            } else if (ItemStack.isSameItemSameComponents((ItemStack)currentCatalystStack, (ItemStack)itemStack)) {
                InventoryHelper.combineStacks(currentCatalystStack, itemStack);
                changed = true;
            }
        }
        if (changed) {
            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.8f, 0.8f + this.level.random.nextFloat() * 0.6f);
            if (player != null) {
                this.ownerUUID = player;
            }
            this.inventoryChanged();
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void onTopBlockChange(BlockState newState, @Nullable RecipeHolder<CrystallarieumRecipe> recipe) {
        if (this.level == null) {
            return;
        }
        if (newState.isAir()) {
            this.currentRecipe = null;
            this.canWork = false;
            this.setChanged();
            this.updateInClientWorld();
        } else {
            ItemStack catalystStack;
            RecipeHolder<CrystallarieumRecipe> recipeHolder = this.currentRecipe = recipe == null ? CrystallarieumRecipe.getRecipeForState(this.level, newState) : recipe;
            if (this.currentRecipe != null && !(catalystStack = this.getItem(0)).isEmpty()) {
                this.currentCatalyst = ((CrystallarieumRecipe)this.currentRecipe.value()).getCatalyst(catalystStack);
                if (this.currentCatalyst == CrystallarieumCatalyst.EMPTY) {
                    ItemEntity itemEntity = new ItemEntity(this.level, (double)this.getBlockPos().getX() + 0.5, (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ() + 0.5, catalystStack);
                    this.setItem(0, ItemStack.EMPTY);
                    this.level.addFreshEntity((Entity)itemEntity);
                }
            }
            this.inventoryChanged();
        }
    }

    @Override
    public IndividualCappedInkStorage getEnergyStorage() {
        return this.inkStorage;
    }

    @Override
    public void setInkDirty() {
        this.inkDirty = true;
    }

    @Override
    public boolean getInkDirty() {
        return this.inkDirty;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 1) {
            return stack.getItem() instanceof InkStorageItem;
        }
        if (this.currentRecipe != null) {
            return ((CrystallarieumRecipe)this.currentRecipe.value()).getCatalyst(stack) != CrystallarieumCatalyst.EMPTY;
        }
        return false;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        if (dir.getAxis().isHorizontal()) {
            return new StackHandlerView(this.inventory, 0).disableExtraction();
        }
        if (dir.getAxis().isVertical()) {
            return new StackHandlerView(this.inventory, 1);
        }
        return null;
    }

    @Override
    public IFluidHandler exposeFluidHandlers(Direction dir) {
        return this.tank;
    }

    static {
        FlowAnimator.Builder<CrystallarieumBlockEntity> builder = new FlowAnimator.Builder<CrystallarieumBlockEntity>(CrystallarieumBlockEntity.class);
        builder.stateInfo(FlowStates.INACTIVE, 30);
        builder.stateInfo(FlowStates.ACTIVE, 15);
        builder.stateInfo(FlowStates.IDLE, 13);
        builder.handle("alpha", FlowHandlers.FLOAT).initial(Float.valueOf(0.1f)).forStates(Float.valueOf(0.1f), FlowStates.INACTIVE).forStates(Float.valueOf(0.4f), FlowStates.IDLE).forStates(Float.valueOf(0.8f), FlowStates.ACTIVE).push();
        builder.handle("speed", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).forStates(Float.valueOf(-0.5f), FlowStates.INACTIVE).forStates(Float.valueOf(1.0f), FlowStates.IDLE).forStates(Float.valueOf(2.5f), FlowStates.ACTIVE).push();
        builder.handle("bounce", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).forStates(Float.valueOf(2.0f), FlowStates.INACTIVE).forStates(Float.valueOf(1.0f), FlowStates.IDLE).forStates(Float.valueOf(4.0f), FlowStates.ACTIVE).push();
        FACTORY = builder.build();
    }
}

