/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.crystallarieum;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.blocks.InWorldInteractionBlock;
import earth.terrarium.pastel.blocks.crystallarieum.CrystallarieumBlockEntity;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class CrystallarieumBlock
extends InWorldInteractionBlock
implements SlotBackgroundEffect {
    public static final MapCodec<CrystallarieumBlock> CODEC = CrystallarieumBlock.simpleCodec(CrystallarieumBlock::new);

    public CrystallarieumBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    public MapCodec<? extends CrystallarieumBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrystallarieumBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return CrystallarieumBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.CRYSTALLARIEUM.get()), (BlockEntityTicker)(world.isClientSide ? CrystallarieumBlockEntity::clientTick : CrystallarieumBlockEntity::serverTick));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (!world.isClientSide() && direction == Direction.UP && (blockEntity = world.getBlockEntity(pos)) instanceof CrystallarieumBlockEntity) {
            CrystallarieumBlockEntity crystallarieumBlockEntity = (CrystallarieumBlockEntity)blockEntity;
            crystallarieumBlockEntity.onTopBlockChange(neighborState, null);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.isClientSide && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof CrystallarieumBlockEntity) {
                CrystallarieumBlockEntity crystallarieumBlockEntity = (CrystallarieumBlockEntity)blockEntity;
                ItemStack stack = itemEntity.getItem();
                crystallarieumBlockEntity.acceptStack(stack, false, itemEntity.getOwner() != null ? itemEntity.getOwner().getUUID() : null);
            }
        } else {
            super.fallOn(world, state, pos, entity, fallDistance);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof CrystallarieumBlockEntity) {
                CrystallarieumBlockEntity crystal = (CrystallarieumBlockEntity)blockEntity;
                if (player.isShiftKeyDown() || stack.isEmpty()) {
                    if (this.retrieveStack(world, pos, player, hand, stack, crystal, 1) || this.retrieveStack(world, pos, player, hand, stack, crystal, 0)) {
                        crystal.inventoryChanged();
                        crystal.setOwner(player);
                    }
                    return ItemInteractionResult.CONSUME;
                }
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)crystal.tank)) {
                    crystal.updateInClientWorld();
                    return ItemInteractionResult.CONSUME;
                }
                Item item = stack.getItem();
                if (item instanceof InkStorageItem) {
                    InkStorageItem inkStorageItem = (InkStorageItem)item;
                    if (inkStorageItem.getDrainability().canDrain(false) && this.exchangeStack(world, pos, player, hand, stack, crystal, 1)) {
                        crystal.inventoryChanged();
                        crystal.setOwner(player);
                    }
                } else if (this.exchangeStack(world, pos, player, hand, stack, crystal, 0)) {
                    crystal.inventoryChanged();
                    crystal.setOwner(player);
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public ItemStack asStackWithColor(InkColor color) {
        ItemStack stack = this.asItem().getDefaultInstance();
        stack.set(PastelDataComponentTypes.INK_COLOR, (Object)color);
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        InkColor color = (InkColor)stack.get(PastelDataComponentTypes.INK_COLOR);
        if (color != null) {
            tooltip.add((Component)color.getColoredInkName());
        }
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        InkColor color = (InkColor)stack.get(PastelDataComponentTypes.INK_COLOR);
        return color != null ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        InkColor color = (InkColor)stack.getOrDefault(PastelDataComponentTypes.INK_COLOR, (Object)InkColors.WHITE);
        return color.getColorInt();
    }
}

