/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.chests.HeartboundChestBlockEntity;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeartboundChestBlockEntityRenderer
implements BlockEntityRenderer<HeartboundChestBlockEntity> {
    private static final Material SPRITE = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/heartbound_chest"));
    private final ModelPart root;
    private final ModelPart bottomLock;
    private final ModelPart cap;
    private final ModelPart topLock;

    public HeartboundChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        LayerDefinition texturedModelData = HeartboundChestBlockEntityRenderer.getTexturedModelData();
        this.root = texturedModelData.bakeRoot();
        this.bottomLock = this.root.getChild("bottomlock");
        this.cap = this.root.getChild("cap");
        this.topLock = this.cap.getChild("toplock");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition bottomlock = modelPartData.addOrReplaceChild("bottomlock", CubeListBuilder.create().texOffs(6, 5).addBox(1.5f, -1.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 5).addBox(-3.5f, -1.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)-7.5f));
        PartDefinition cap = modelPartData.addOrReplaceChild("cap", CubeListBuilder.create().texOffs(0, 0).addBox(-7.5f, -5.0f, -14.5f, 15.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)7.0f));
        PartDefinition toplock = cap.addOrReplaceChild("toplock", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.0f, -0.5f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-14.5f));
        PartDefinition bb_main = modelPartData.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 20).addBox(-7.0f, -10.0f, -7.0f, 14.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void render(HeartboundChestBlockEntity chest, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        VertexConsumer vertexConsumer = SPRITE.buffer(vertexConsumers, RenderType::entitySolid);
        boolean bl = chest.getLevel() != null;
        BlockState blockState = bl ? chest.getBlockState() : (BlockState)((Block)PastelBlocks.HEARTBOUND_CHEST.get()).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        float f = blockState.hasProperty((Property)ChestBlock.FACING) ? ((Direction)blockState.getValue((Property)ChestBlock.FACING)).toYRot() : 0.0f;
        matrices.translate(0.5, 1.5, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees(-f));
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        float openFactor = chest.getOpenNess(tickDelta);
        openFactor = 1.0f - openFactor;
        openFactor = 1.0f - openFactor * openFactor * openFactor;
        this.cap.xRot = -(openFactor * 1.5707964f);
        this.root.render(matrices, vertexConsumer, light, overlay);
        matrices.popPose();
    }
}

