/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntity;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.inventories.FabricationChestScreenHandler;
import earth.terrarium.pastel.items.magic_items.CraftingTabletItem;
import earth.terrarium.pastel.networking.s2c_payloads.FabricationChestStatusUpdatePayload;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class FabricationChestBlockEntity
extends PastelChestBlockEntity
implements WorldlyContainer {
    public static final int[] CHEST_SLOTS = IntStream.rangeClosed(0, 26).toArray();
    public static final int[] RECIPE_SLOTS = IntStream.rangeClosed(27, 30).toArray();
    public static final int[] RESULT_SLOTS = IntStream.rangeClosed(31, 34).toArray();
    public static final int INVENTORY_SIZE = CHEST_SLOTS.length + RECIPE_SLOTS.length + RESULT_SLOTS.length;
    private List<ItemStack> cachedOutputs = new ArrayList<ItemStack>(4);
    private int coolDownTicks = 0;
    private boolean isOpen;
    private boolean isFull;
    private boolean hasValidRecipes;
    private State state = State.CLOSED;
    float rimTarget;
    float rimPos;
    float lastRimTarget;
    float tabletTarget;
    float tabletPos;
    float lastTabletTarget;
    float assemblyTarget;
    float assemblyPos;
    float lastAssemblyTarget;
    float ringTarget;
    float ringPos;
    float lastRingTarget;
    float itemTarget;
    float itemPos;
    float lastItemTarget;
    float alphaTarget;
    float alphaValue;
    float lastAlphaTarget;
    float yawModTarget;
    float yawMod;
    float lastYawModTarget;
    float yaw;
    float lastYaw;
    long interpTicks;
    long interpLength = 1L;
    long age;

    public FabricationChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.FABRICATION_CHEST.get(), blockPos, blockState);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, FabricationChestBlockEntity chest) {
        ++chest.age;
        if (world.isClientSide) {
            chest.lastYaw = chest.yaw;
            chest.yaw += chest.yawMod;
            if (chest.isOpen) {
                if (chest.canFunction()) {
                    chest.changeState(State.OPEN_CRAFTING);
                    chest.interpLength = 5L;
                } else {
                    chest.changeState(State.OPEN);
                    chest.interpLength = 7L;
                }
            } else if (chest.isFull) {
                chest.changeState(State.FULL);
                chest.interpLength = 9L;
            } else if (chest.canFunction()) {
                chest.changeState(State.CLOSED_CRAFTING);
                chest.interpLength = 7L;
            } else {
                chest.changeState(State.CLOSED);
                chest.interpLength = 13L;
            }
            if (chest.interpTicks < chest.interpLength) {
                ++chest.interpTicks;
            }
            chest.lidAnimator.tickLid();
        } else if (FabricationChestBlockEntity.tickCooldown(chest)) {
            for (int i = 0; i < 4; ++i) {
                boolean couldCraft;
                ItemStack outputItemStack = chest.inventory.getStackInSlot(RESULT_SLOTS[i]);
                ItemStack craftingTabletItemStack = chest.inventory.getStackInSlot(RECIPE_SLOTS[i]);
                if (craftingTabletItemStack.isEmpty() || !outputItemStack.isEmpty() && outputItemStack.getCount() >= outputItemStack.getMaxStackSize() || !(couldCraft = chest.tryCraft(chest, i))) continue;
                chest.setCooldown(chest, 20);
                chest.setChanged();
                chest.updateFullState(false);
                return;
            }
        }
    }

    public void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.lastRimTarget = this.rimPos;
            this.lastTabletTarget = this.tabletPos;
            this.lastAssemblyTarget = this.assemblyPos;
            this.lastRingTarget = this.ringPos;
            this.lastItemTarget = this.itemPos;
            this.lastAlphaTarget = this.alphaValue;
            this.lastYawModTarget = this.yawMod;
            this.interpTicks = 0L;
        }
    }

    @Override
    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.isOpen = data > 0;
        }
        return super.triggerEvent(type, data);
    }

    private static boolean tickCooldown(FabricationChestBlockEntity fabricationChestBlockEntity) {
        --fabricationChestBlockEntity.coolDownTicks;
        if (fabricationChestBlockEntity.coolDownTicks > 0) {
            return false;
        }
        fabricationChestBlockEntity.coolDownTicks = 0;
        return true;
    }

    public List<ItemStack> getRecipeOutputs() {
        if (this.level == null || this.level.isClientSide()) {
            return this.cachedOutputs;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int slot : RECIPE_SLOTS) {
            ItemStack output;
            Recipe recipe;
            ItemStack tablet = this.inventory.getStackInSlot(slot);
            if (!tablet.is((Item)PastelItems.CRAFTING_TABLET.get()) || !FabricationChestBlockEntity.isRecipeValid(recipe = CraftingTabletItem.getStoredRecipe(this.level, tablet).value()) || (output = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess())).isEmpty()) continue;
            list.add(output);
        }
        return list;
    }

    public long getRenderTime() {
        return this.age % 50000L;
    }

    public boolean hasValidRecipes() {
        if (this.level == null || this.level.isClientSide()) {
            return this.hasValidRecipes;
        }
        for (int i = 0; i < 4; ++i) {
            Recipe recipe;
            ItemStack tablet = this.inventory.getStackInSlot(RECIPE_SLOTS[i]);
            if (!tablet.is((Item)PastelItems.CRAFTING_TABLET.get()) || !FabricationChestBlockEntity.isRecipeValid(recipe = CraftingTabletItem.getStoredRecipe(this.level, tablet).value()) || !this.isRecipeCraftable(recipe) || !this.canSlotFitCraftingOutput(this.inventory.getStackInSlot(RESULT_SLOTS[i]), recipe)) continue;
            return true;
        }
        return false;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.pastel.fabrication_chest");
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new FabricationChestScreenHandler(syncId, playerInventory, (Container)this);
    }

    private void setCooldown(FabricationChestBlockEntity fabricationChestBlockEntity, int cooldownTicks) {
        fabricationChestBlockEntity.coolDownTicks = cooldownTicks;
    }

    private boolean tryCraft(FabricationChestBlockEntity chest, int index) {
        RecipeHolder<?> recipe;
        ItemStack craftingTabletItemStack = chest.inventory.getStackInSlot(RECIPE_SLOTS[index]);
        if (craftingTabletItemStack.is((Item)PastelItems.CRAFTING_TABLET.get()) && (recipe = CraftingTabletItem.getStoredRecipe(this.level, craftingTabletItemStack)) != null && FabricationChestBlockEntity.isRecipeValid(recipe.value())) {
            NonNullList ingredients = recipe.value().getIngredients();
            ItemStack outputItemStack = recipe.value().getResultItem((HolderLookup.Provider)this.level.registryAccess());
            ItemStack currentItemStack = chest.inventory.getStackInSlot(RESULT_SLOTS[index]);
            if (InventoryHelper.canCombineItemStacks(currentItemStack, outputItemStack) && InventoryHelper.hasInInventory((List<Ingredient>)ingredients, (IItemHandlerModifiable)chest.inventory)) {
                List<ItemStack> remainders = InventoryHelper.removeFromInventoryWithRemainders((List<Ingredient>)ingredients, (IItemHandlerModifiable)chest.inventory);
                if (currentItemStack.isEmpty()) {
                    chest.inventory.setStackInSlot(RESULT_SLOTS[index], outputItemStack.copy());
                } else {
                    currentItemStack.grow(outputItemStack.getCount());
                }
                for (ItemStack remainder : remainders) {
                    InventoryHelper.smartAddToInventory(remainder, (IItemHandlerModifiable)chest.inventory, null);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isRecipeValid(Recipe<?> recipe) {
        return recipe instanceof ShapelessRecipe || recipe instanceof ShapedRecipe;
    }

    private boolean isRecipeCraftable(Recipe<?> recipe) {
        NonNullList ingredients = recipe.getIngredients();
        if (!InventoryHelper.hasInInventory((List<Ingredient>)ingredients, (IItemHandlerModifiable)this.inventory)) {
            return false;
        }
        List<ItemStack> remainders = InventoryHelper.getRemainders((List<Ingredient>)ingredients);
        return InventoryHelper.canFitStacks((IItemHandlerModifiable)this.inventory, remainders);
    }

    public int getContainerSize() {
        return INVENTORY_SIZE;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        tag.putInt("cooldown", this.coolDownTicks);
        tag.putLong("age", this.age);
        if (this.level != null && this.level.isClientSide()) {
            tag.putFloat("yaw", this.yaw);
            tag.putFloat("lastYaw", this.lastYaw);
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        if (tag.contains("cooldown")) {
            this.coolDownTicks = tag.getInt("cooldown");
        }
        if (tag.contains("age")) {
            this.age = tag.getLong("age");
        }
        if (tag.contains("yaw")) {
            this.yaw = tag.getFloat("yaw");
        }
        if (tag.contains("lastYaw")) {
            this.lastYaw = tag.getFloat("lastYaw");
        }
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return RESULT_SLOTS;
        }
        return CHEST_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return slot <= CHEST_SLOTS[CHEST_SLOTS.length - 1];
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public boolean canFunction() {
        return !this.isFull && this.hasValidRecipes();
    }

    public void updateFullState(boolean force) {
        if (this.level != null && !this.level.isClientSide()) {
            boolean wasFull = this.isFull;
            this.isFull = this.isFull();
            boolean hadValidRecipes = this.hasValidRecipes;
            this.hasValidRecipes = this.hasValidRecipes();
            if (force || wasFull != this.isFull || hadValidRecipes != this.hasValidRecipes) {
                FabricationChestStatusUpdatePayload.sendFabricationChestStatusUpdate(this);
            }
        }
    }

    public boolean isFullServer() {
        return this.isFull;
    }

    public boolean isFull() {
        int invalids = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack tablet = this.inventory.getStackInSlot(RECIPE_SLOTS[i]);
            if (!tablet.is((Item)PastelItems.CRAFTING_TABLET.get())) continue;
            RecipeHolder<?> recipe = CraftingTabletItem.getStoredRecipe(this.level, tablet);
            if (recipe == null || !FabricationChestBlockEntity.isRecipeValid(recipe.value())) {
                ++invalids;
                continue;
            }
            ItemStack outputSlot = this.inventory.getStackInSlot(RESULT_SLOTS[i]);
            if (!this.canSlotFitCraftingOutput(outputSlot, recipe.value())) continue;
            return false;
        }
        return invalids != 4;
    }

    public boolean canSlotFitCraftingOutput(ItemStack slot, Recipe<?> recipe) {
        if (this.level == null) {
            return false;
        }
        return slot.isEmpty() || slot.getCount() + recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount() < slot.getMaxStackSize();
    }

    @Override
    protected void onInvOpenOrClose(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        super.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
        this.updateFullState(true);
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.updateFullState(false);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = super.removeItem(slot, amount);
        if (!stack.isEmpty()) {
            this.updateFullState(false);
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = super.removeItemNoUpdate(slot);
        if (!stack.isEmpty()) {
            this.updateFullState(false);
        }
        return stack;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        if (dir.getAxis().isVertical()) {
            return new StackHandlerView(this.inventory, RESULT_SLOTS[0], RESULT_SLOTS.length);
        }
        return new StackHandlerView(this.inventory, 0, CHEST_SLOTS.length);
    }

    public void updateState(boolean full, boolean hasValidRecipes, List<ItemStack> cachedOutputs) {
        this.isFull = full;
        this.hasValidRecipes = hasValidRecipes;
        this.cachedOutputs = cachedOutputs;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        OPEN,
        OPEN_CRAFTING,
        CLOSED_CRAFTING,
        CLOSED,
        FULL;

    }
}

