/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.bottomless_bundle;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleBlockEntity;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleItem;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class BottomlessBundleBlock
extends BaseEntityBlock {
    public static final MapCodec<BottomlessBundleBlock> CODEC = BottomlessBundleBlock.simpleCodec(BottomlessBundleBlock::new);
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    public static final int MAX_ROTATIONS = RotationSegment.getMaxSegmentIndex() + 1;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public BottomlessBundleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BottomlessBundleBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.isClientSide) {
            if (player.isShiftKeyDown()) {
                world.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.BOTTOMLESS_BUNDLE.get()).ifPresent(bundle -> {
                    long amount = bundle.getStoredAmount();
                    ItemStack ref = bundle.storage.getStackInSlot(0);
                    long maxStoredAmount = BottomlessBundleItem.getMaxStoredAmount(bundle.powerLevel);
                    if (ref.isEmpty()) {
                        player.displayClientMessage((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.empty"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.count_of", (Object[])new Object[]{amount, maxStoredAmount}).append(ref.getItem().getDescription()), true);
                    }
                });
            } else {
                world.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.BOTTOMLESS_BUNDLE.get()).ifPresent(bottomlessBundleBlockEntity -> {
                    IItemHandler storage = bottomlessBundleBlockEntity.storage;
                    ItemStack ref = storage.getStackInSlot(0);
                    if (ItemStack.isSameItemSameComponents((ItemStack)ref, (ItemStack)stack) || ref.isEmpty()) {
                        if (!stack.isEmpty() && stack.getItem().canFitInsideContainerItems()) {
                            stack.setCount(storage.insertItem(0, stack, false).getCount());
                            world.playSound(null, pos, SoundEvents.BUNDLE_INSERT, SoundSource.BLOCKS, 0.8f, 0.8f + world.getRandom().nextFloat() * 0.4f);
                        }
                    } else {
                        ItemStack extracted = storage.extractItem(0, ref.getItem().getMaxStackSize(ref), false);
                        player.getInventory().placeItemBackInInventory(extracted);
                        world.playSound(null, pos, SoundEvents.BUNDLE_REMOVE_ONE, SoundSource.BLOCKS, 0.8f, 0.8f + world.getRandom().nextFloat() * 0.4f);
                    }
                    bottomlessBundleBlockEntity.setChanged();
                });
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ((Block)PastelBlocks.BOTTOMLESS_BUNDLE.get()).asItem().getDefaultInstance();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof BottomlessBundleBlockEntity) {
            BottomlessBundleBlockEntity bottomlessBundleBlockEntity = (BottomlessBundleBlockEntity)blockEntity;
            return List.of(bottomlessBundleBlockEntity.retrieveBundle());
        }
        return super.getDrops(state, builder);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BottomlessBundleBlockEntity) {
            float max;
            BottomlessBundleBlockEntity bundle = (BottomlessBundleBlockEntity)blockEntity;
            float curr = bundle.storage.getStackInSlot(0).getCount();
            return (float)Mth.floor((float)(curr / (max = (float)BottomlessBundleItem.getMaxStoredAmount(bundle.powerLevel)) * 14.0f)) + curr > 0.0f ? 1 : 0;
        }
        return 0;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BottomlessBundleBlockEntity) {
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)ctx.getRotation())))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(ctx.getItemInHand().has(DataComponents.LOCK)));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof BottomlessBundleBlockEntity) {
            BottomlessBundleBlockEntity bottomlessBundleBlockEntity = (BottomlessBundleBlockEntity)blockEntity;
            bottomlessBundleBlockEntity.setBundle(itemStack.copy(), (HolderLookup.Provider)world.registryAccess());
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
    }

    public MutableComponent getName() {
        return Component.translatable((String)"item.pastel.bottomless_bundle");
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.ROTATION_16, LOCKED});
    }
}

