/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallCropBlock
extends CropBlock {
    public static final MapCodec<TallCropBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TallCropBlock.propertiesCodec(), (App)Codec.INT.fieldOf("last_single_block_age").forGetter(TallCropBlock::getLastSingleBlockAge)).apply((Applicative)instance, TallCropBlock::new));
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public final int lastSingleBlockAge;

    public TallCropBlock(BlockBehaviour.Properties settings, int lastSingleBlockAge) {
        super(settings);
        this.lastSingleBlockAge = lastSingleBlockAge;
    }

    public MapCodec<? extends TallCropBlock> codec() {
        return CODEC;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tryGrow(state, world, pos, random, 25.0f);
    }

    public void growCrops(Level world, BlockPos pos, BlockState state) {
        int maxAge;
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.below();
            state = world.getBlockState(pos);
        }
        if (!state.is((Block)this)) {
            return;
        }
        int newAge = this.getAge(state) + this.getBonemealAgeIncrease(world);
        if (newAge > (maxAge = this.getMaxAge())) {
            newAge = maxAge;
        }
        if (newAge > this.lastSingleBlockAge && this.canGrowUp(world, pos, state, newAge)) {
            world.setBlock(pos, this.getStateForAge(newAge), 2);
            world.setBlock(pos.above(), this.withAgeAndHalf(newAge, DoubleBlockHalf.UPPER), 2);
        } else {
            world.setBlock(pos, this.getStateForAge(Math.min(newAge, this.lastSingleBlockAge)), 2);
        }
    }

    private boolean canGrowUp(Level world, BlockPos pos, BlockState state, int age) {
        return world.getBlockState(pos.above()).is((Block)this) || world.getBlockState(pos.above()).canBeReplaced();
    }

    protected void tryGrow(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, float upperBound) {
        float moisture;
        int age;
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (world.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) < this.getMaxAge() && random.nextInt((int)(upperBound / (moisture = TallCropBlock.getGrowthSpeed((BlockState)state, (BlockGetter)world, (BlockPos)pos))) + 1) == 0) {
            if (age >= 2) {
                if (world.getBlockState(pos.above()).is((Block)this) || world.getBlockState(pos.above()).canBeReplaced()) {
                    world.setBlock(pos, this.getStateForAge(age + 1), 2);
                    world.setBlock(pos.above(), this.withAgeAndHalf(age + 1, DoubleBlockHalf.UPPER), 2);
                }
            } else {
                world.setBlock(pos, this.getStateForAge(age + 1), 2);
            }
        }
    }

    public BlockState getStateForAge(int age) {
        return this.withAgeAndHalf(age, DoubleBlockHalf.LOWER);
    }

    public BlockState withAgeAndHalf(int age, DoubleBlockHalf half) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age))).setValue(HALF, (Comparable)half);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF}).add(new Property[]{AGE});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            BlockPos blockPos = pos.below();
            return this.mayPlaceOn(world.getBlockState(blockPos), (BlockGetter)world, blockPos);
        }
        BlockState blockState = world.getBlockState(pos.below());
        return blockState.is((Block)this) && blockState.getValue(HALF) == DoubleBlockHalf.LOWER && (Integer)blockState.getValue((Property)AGE) > this.lastSingleBlockAge;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if ((Integer)state.getValue((Property)AGE) <= this.lastSingleBlockAge) {
                return super.getShape(state, world, pos, context);
            }
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return super.getShape(this.getStateForAge((Integer)state.getValue((Property)AGE) - this.lastSingleBlockAge - 1), world, pos, context);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return (Integer)state.getValue((Property)AGE) <= this.lastSingleBlockAge || neighborState.is((Block)this) && neighborState.getValue(HALF) != doubleBlockHalf ? state : Blocks.AIR.defaultBlockState();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        return blockPos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(blockPos.above()).canBeReplaced(ctx) ? this.withAgeAndHalf(0, DoubleBlockHalf.LOWER) : null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            world.setBlock(pos.below(), this.withAgeAndHalf((Integer)state.getValue((Property)AGE), DoubleBlockHalf.LOWER), 3);
        } else if ((Integer)state.getValue((Property)AGE) > this.lastSingleBlockAge) {
            world.setBlock(pos.above(), this.withAgeAndHalf((Integer)state.getValue((Property)AGE), DoubleBlockHalf.UPPER), 3);
        }
    }

    protected static void breakTheOtherHalf(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos downPos = pos.below();
            BlockState blockState = world.getBlockState(downPos);
            if (blockState.is(state.getBlock()) && blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
                if (!player.isCreative()) {
                    TallCropBlock.dropResources((BlockState)state, (Level)world, (BlockPos)downPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                }
                BlockState blockState2 = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                world.setBlock(downPos, blockState2, 35);
                world.levelEvent(player, 2001, downPos, Block.getId((BlockState)blockState));
            }
        } else {
            BlockPos upPos = pos.above();
            BlockState blockState = world.getBlockState(upPos);
            if (blockState.is(state.getBlock()) && blockState.getValue(HALF) == DoubleBlockHalf.UPPER) {
                if (!player.isCreative()) {
                    TallCropBlock.dropResources((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                }
                BlockState blockState2 = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                world.setBlock(upPos, blockState2, 35);
                world.levelEvent(player, 2001, upPos, Block.getId((BlockState)blockState));
            }
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            TallCropBlock.breakTheOtherHalf(world, pos, state, player);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(world, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
    }

    public int getLastSingleBlockAge() {
        return this.lastSingleBlockAge;
    }
}

