/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import earth.terrarium.pastel.blocks.PlacedItemBlockEntity;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public abstract class PlacedItemBlock
extends BaseEntityBlock {
    public PlacedItemBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PlacedItemBlockEntity(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PlacedItemBlockEntity) {
            PlacedItemBlockEntity placedItemBlockEntity = (PlacedItemBlockEntity)blockEntity;
            ItemStack placedStack = stack.copy();
            placedStack.setCount(1);
            placedItemBlockEntity.setStack(placedStack);
            if (placer instanceof Player) {
                Player playerPlacer = (Player)placer;
                placedItemBlockEntity.setOwner(playerPlacer);
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        Optional blockEntity = world.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.PLACED_ITEM.get());
        if (blockEntity.isPresent()) {
            return ((PlacedItemBlockEntity)blockEntity.get()).getStack().copy();
        }
        return ItemStack.EMPTY;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof PlacedItemBlockEntity) {
            PlacedItemBlockEntity placedItemBlockEntity = (PlacedItemBlockEntity)blockEntity;
            return List.of(placedItemBlockEntity.getStack());
        }
        return super.getDrops(state, builder);
    }
}

