/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.recipe;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.registries.PastelFusionShrineWorldEffects;
import earth.terrarium.pastel.registries.PastelRegistries;
import io.netty.buffer.ByteBuf;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public interface FusionShrineRecipeWorldEffect {
    public static final Codec<FusionShrineRecipeWorldEffect> CODEC = Codec.STRING.xmap(FusionShrineRecipeWorldEffect::fromString, effect -> {
        String string;
        if (effect instanceof CommandRecipeWorldEffect) {
            CommandRecipeWorldEffect command = (CommandRecipeWorldEffect)effect;
            string = command.command;
        } else {
            string = String.valueOf(PastelRegistries.WORLD_EFFECT.getKey(effect));
        }
        return string;
    });
    public static final StreamCodec<ByteBuf, FusionShrineRecipeWorldEffect> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(FusionShrineRecipeWorldEffect::fromString, effect -> {
        String string;
        if (effect instanceof CommandRecipeWorldEffect) {
            CommandRecipeWorldEffect command = (CommandRecipeWorldEffect)effect;
            string = command.command;
        } else {
            string = String.valueOf(PastelRegistries.WORLD_EFFECT.getKey(effect));
        }
        return string;
    });
    public static final FusionShrineRecipeWorldEffect NOTHING = FusionShrineRecipeWorldEffect.register("nothing", new SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
        }
    });

    public static FusionShrineRecipeWorldEffect register(String id, FusionShrineRecipeWorldEffect effect) {
        PastelFusionShrineWorldEffects.REGISTER.register(id, () -> effect);
        return effect;
    }

    public static FusionShrineRecipeWorldEffect fromString(String string) {
        if (string == null || string.isBlank()) {
            return NOTHING;
        }
        if (string.startsWith("/")) {
            return new CommandRecipeWorldEffect(string);
        }
        FusionShrineRecipeWorldEffect effect = (FusionShrineRecipeWorldEffect)PastelRegistries.WORLD_EFFECT.get(PastelCommon.ofPastel(string));
        if (effect == null) {
            PastelCommon.logError("Unknown fusion shrine world effect '" + string + "'. Will be ignored.");
            return NOTHING;
        }
        return effect;
    }

    public boolean isOneTimeEffect();

    public void trigger(ServerLevel var1, BlockPos var2);

    public static class CommandRecipeWorldEffect
    implements FusionShrineRecipeWorldEffect,
    CommandSource {
        protected final String command;

        public CommandRecipeWorldEffect(String command) {
            this.command = command;
        }

        public static CommandRecipeWorldEffect fromJson(JsonObject json) {
            return new CommandRecipeWorldEffect(json.getAsString());
        }

        @Override
        public boolean isOneTimeEffect() {
            return false;
        }

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            MinecraftServer minecraftServer = world.getServer();
            CommandSourceStack serverCommandSource = new CommandSourceStack((CommandSource)this, Vec3.atCenterOf((Vec3i)pos), Vec2.ZERO, world, 2, "FusionShrine", (Component)world.getBlockState(pos).getBlock().getName(), minecraftServer, null);
            minecraftServer.getCommands().performPrefixedCommand(serverCommandSource, this.command);
        }

        public void sendSystemMessage(Component message) {
        }

        public boolean acceptsSuccess() {
            return false;
        }

        public boolean acceptsFailure() {
            return false;
        }

        public boolean shouldInformAdmins() {
            return false;
        }
    }

    public static abstract class SingleTimeRecipeWorldEffect
    implements FusionShrineRecipeWorldEffect {
        @Override
        public boolean isOneTimeEffect() {
            return true;
        }
    }

    public static abstract class EveryTickRecipeWorldEffect
    implements FusionShrineRecipeWorldEffect {
        @Override
        public boolean isOneTimeEffect() {
            return false;
        }
    }
}

