/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.predicate.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.components.InfusedBeverageComponent;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.Optional;
import net.minecraft.advancements.critereon.SingleComponentItemPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public record InfusedBeveragePredicate(Optional<String> variant) implements SingleComponentItemPredicate<InfusedBeverageComponent>
{
    public static final Codec<InfusedBeveragePredicate> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("variant").forGetter(c -> c.variant)).apply((Applicative)i, InfusedBeveragePredicate::new));

    public DataComponentType<InfusedBeverageComponent> componentType() {
        return PastelDataComponentTypes.INFUSED_BEVERAGE;
    }

    public boolean matches(ItemStack stack, InfusedBeverageComponent component) {
        return this.variant.isEmpty() || component.variant().equals(this.variant.get());
    }
}

