/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import earth.terrarium.pastel.api.item.StampDataCategory;
import earth.terrarium.pastel.helpers.level.BlockReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface Stampable {
    public static final String STAMPING_DATA_TAG = "pastel:stamping_data";

    public StampData recordStampData(Optional<Player> var1, BlockReference var2, Level var3);

    public boolean handleImpression(Optional<UUID> var1, Optional<Player> var2, BlockReference var3, Level var4);

    public void clearImpression();

    public StampDataCategory getStampCategory();

    public boolean canUserStamp(Optional<Player> var1);

    public static CompoundTag saveStampingData(StampData data) {
        CompoundTag compound = new CompoundTag();
        data.stamper.ifPresent(uuid -> compound.putUUID("stamper", uuid));
        if (data.reference == null) {
            throw new IllegalStateException("Attempted to save stamp data without a BlockReference!");
        }
        compound.putLong("source", data.reference.pos.asLong());
        return compound;
    }

    public static Optional<StampData> loadStampingData(Level world, CompoundTag nbt) {
        Tuple<Optional<Stampable>, BlockReference> sourcePair = Stampable.findSource(world, nbt);
        Optional source = (Optional)sourcePair.getA();
        if (source.isEmpty()) {
            return Optional.empty();
        }
        Optional<UUID> stamper = Optional.empty();
        if (nbt.hasUUID("stamper")) {
            stamper = Optional.of(nbt.getUUID("stamper"));
        }
        return Optional.of(new StampData(stamper, (BlockReference)sourcePair.getB(), (Stampable)source.get()));
    }

    private static Tuple<Optional<Stampable>, BlockReference> findSource(Level world, CompoundTag nbt) {
        Stampable interactable;
        Stampable stampInteractable = null;
        if (!nbt.contains("source")) {
            return new Tuple(Optional.empty(), null);
        }
        BlockPos pos = BlockPos.of((long)nbt.getLong("source"));
        BlockState state = world.getBlockState(pos);
        BlockReference reference = BlockReference.of(state, pos);
        Block block = state.getBlock();
        if (block instanceof Stampable) {
            stampInteractable = interactable = (Stampable)block;
        }
        if ((block = world.getBlockEntity(pos)) instanceof Stampable) {
            stampInteractable = interactable = (Stampable)block;
            reference = reference.appendBE((BlockEntity)interactable);
        }
        return new Tuple(Optional.ofNullable(stampInteractable), (Object)reference);
    }

    default public boolean verifyStampData(StampData data) {
        if (data.source.getStampCategory() == StampDataCategory.UNIQUE) {
            return this.verifyUniqueStampData(data);
        }
        return data.source.getStampCategory() == this.getStampCategory();
    }

    @ApiStatus.OverrideOnly
    default public boolean verifyUniqueStampData(StampData data) {
        return true;
    }

    public void onImpressedOther(StampData var1, boolean var2);

    public record StampData(Optional<UUID> stamper, BlockReference reference, Stampable source) {
        public StampData(@Nullable Entity stamper, BlockReference reference, Stampable source) {
            this(Optional.ofNullable(stamper).map(Entity::getUUID), reference, source);
        }

        public boolean verifyStampData(StampData data) {
            return this.source.verifyStampData(data);
        }

        public void notifySourceOfChange(StampData data, boolean success) {
            this.source.onImpressedOther(data, success);
        }

        public boolean canUserStamp(Optional<Player> player) {
            return this.source.canUserStamp(player);
        }
    }
}

