/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import earth.terrarium.pastel.progression.GravityAdvancementsManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface GravitableItem {
    public float getGravityMod(ItemStack var1);

    default public double applyGravity(ItemStack stack, Level world, Entity entity) {
        if (world != null && entity != null && entity.isPushable() && !entity.isNoGravity() && !entity.isSpectator()) {
            Player player;
            if (entity instanceof Player && (player = (Player)entity).isCreative()) {
                return 0.0;
            }
            double additionalYVelocity = this.getGravityMod(stack) * (float)Math.min(stack.getCount(), 1024);
            additionalYVelocity = Math.clamp(additionalYVelocity, -50.0, 50.0);
            entity.push(0.0, additionalYVelocity, 0.0);
            if (additionalYVelocity > 0.0 && entity.getDeltaMovement().y > -0.4) {
                entity.fallDistance = 0.0f;
            }
            if (world.getGameTime() % 20L == 0L && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                GravityAdvancementsManager.processAppliedGravityForAdvancements(serverPlayerEntity, additionalYVelocity);
            }
            return additionalYVelocity;
        }
        return 0.0;
    }

    default public void applyGravity(ItemStack stack, Level world, ItemEntity itemEntity) {
        if (itemEntity.isNoGravity()) {
            return;
        }
        if (itemEntity.position().y() > (double)(world.getMaxBuildHeight() + 200)) {
            itemEntity.discard();
        } else {
            itemEntity.push(0.0, (double)(this.getGravityMod(stack) * 10.0f), 0.0);
        }
    }
}

