/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.interaction.projectile_behavior;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.interaction.projectile_behavior.DamagingProjectileBehavior;
import earth.terrarium.pastel.api.interaction.projectile_behavior.ProjectileBehaviorType;
import earth.terrarium.pastel.entity.entity.ItemProjectileEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public record MusicDiscProjectileBehavior() implements DamagingProjectileBehavior
{
    public static final MusicDiscProjectileBehavior INSTANCE = new MusicDiscProjectileBehavior();
    public static final ProjectileBehaviorType<MusicDiscProjectileBehavior> TYPE = new ProjectileBehaviorType(PastelCommon.ofPastel("music_disc"), MapCodec.unit((Object)INSTANCE));

    @Override
    public boolean destroyItemOnHit() {
        return false;
    }

    @Override
    public boolean dealDamage(ThrowableItemProjectile projectile, Entity owner, Entity target) {
        return target.hurt(target.damageSources().thrown((Entity)projectile, owner), 6.0f);
    }

    @Override
    public ItemStack onBlockHit(ItemProjectileEntity projectile, ItemStack stack, @Nullable Entity owner, BlockHitResult hitResult) {
        Level world = projectile.level();
        BlockEntity blockEntity = world.getBlockEntity(hitResult.getBlockPos());
        if (blockEntity instanceof JukeboxBlockEntity) {
            JukeboxBlockEntity jukeboxBlockEntity = (JukeboxBlockEntity)blockEntity;
            if (!blockEntity.isRemoved()) {
                ItemStack currentStack = jukeboxBlockEntity.getItem(0);
                if (!currentStack.isEmpty()) {
                    jukeboxBlockEntity.popOutTheItem();
                }
                jukeboxBlockEntity.setTheItem(stack.copy());
                stack.shrink(1);
            }
        }
        return stack;
    }

    @Override
    public ProjectileBehaviorType<?> type() {
        return TYPE;
    }
}

